/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.neon.api.icon.NeonIcon;
import org.pushingpixels.substance.api.colorscheme.SchemeBaseColors;
import org.pushingpixels.substance.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.substance.api.trait.SubstanceTrait;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.filters.ColorSchemeFilter;

public interface SubstanceColorScheme
extends SubstanceTrait,
SchemeBaseColors,
SchemeDerivedColors {
    public boolean isDark();

    public SubstanceColorScheme shift(Color var1, double var2, Color var4, double var5);

    public SubstanceColorScheme shiftBackground(Color var1, double var2);

    public SubstanceColorScheme tint(double var1);

    public SubstanceColorScheme tone(double var1);

    public SubstanceColorScheme shade(double var1);

    public SubstanceColorScheme saturate(double var1);

    public SubstanceColorScheme invert();

    public SubstanceColorScheme negate();

    public SubstanceColorScheme hueShift(double var1);

    public SubstanceColorScheme blendWith(SubstanceColorScheme var1, double var2);

    public SubstanceColorScheme named(String var1);

    default public NeonIcon.ColorFilter getColorFilter(float brightnessFactor, float alpha) {
        SubstanceColorScheme origin = this;
        return color -> {
            int[] interpolated = ColorSchemeFilter.getInterpolatedColors(origin);
            int steps = interpolated.length;
            int brightness = SubstanceColorUtilities.getColorBrightness(color.getRGB());
            int a = color.getAlpha();
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            float[] hsb = Color.RGBtoHSB(r, g, b, null);
            int pixelColor = interpolated[brightness * steps / 256];
            int ri = pixelColor >>> 16 & 0xFF;
            int gi = pixelColor >>> 8 & 0xFF;
            int bi = pixelColor >>> 0 & 0xFF;
            float[] hsbi = Color.RGBtoHSB(ri, gi, bi, null);
            hsb[0] = hsbi[0];
            hsb[1] = hsbi[1];
            hsb[2] = brightnessFactor >= 0.0f ? brightnessFactor * hsb[2] + (1.0f - brightnessFactor) * hsbi[2] : hsb[2] * hsbi[2] * (1.0f + brightnessFactor);
            Color converted = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            int finalAlpha = (int)((float)a * alpha);
            return new Color(converted.getRed(), converted.getGreen(), converted.getBlue(), finalAlpha);
        };
    }
}

