/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public final class SubstanceSlices {

    public static final class ComponentStateFacet {
        int value;
        String name;
        public static final ComponentStateFacet ENABLE = new ComponentStateFacet("enable", 0);
        public static final ComponentStateFacet ROLLOVER = new ComponentStateFacet("rollover", 10);
        public static final ComponentStateFacet SELECTION = new ComponentStateFacet("selection", 10);
        public static final ComponentStateFacet PRESS = new ComponentStateFacet("press", 50);
        public static final ComponentStateFacet ARM = new ComponentStateFacet("arm", 10);
        public static final ComponentStateFacet DEFAULT = new ComponentStateFacet("default", 500);
        public static final ComponentStateFacet DETERMINATE = new ComponentStateFacet("determinate", 10);

        public ComponentStateFacet(String name, int value) {
            this.name = name;
            if (value < 0) {
                throw new IllegalArgumentException("Facet value must be non-negative");
            }
            this.value = value;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }

    public static final class ColorSchemeAssociationKind {
        private static Set<ColorSchemeAssociationKind> values = new HashSet<ColorSchemeAssociationKind>();
        private String name;
        private ColorSchemeAssociationKind fallback;
        public static final ColorSchemeAssociationKind FILL = new ColorSchemeAssociationKind("fill", null);
        public static final ColorSchemeAssociationKind SEPARATOR = new ColorSchemeAssociationKind("separator", FILL);
        public static final ColorSchemeAssociationKind TAB = new ColorSchemeAssociationKind("tab", FILL);
        public static final ColorSchemeAssociationKind BORDER = new ColorSchemeAssociationKind("border", FILL);
        public static final ColorSchemeAssociationKind MARK = new ColorSchemeAssociationKind("mark", BORDER);
        public static final ColorSchemeAssociationKind MARK_BOX = new ColorSchemeAssociationKind("markBox", FILL);
        public static final ColorSchemeAssociationKind FOCUS = new ColorSchemeAssociationKind("focus", MARK);
        public static final ColorSchemeAssociationKind TAB_BORDER = new ColorSchemeAssociationKind("tabBorder", BORDER);
        public static final ColorSchemeAssociationKind HIGHLIGHT = new ColorSchemeAssociationKind("highlight", FILL);
        public static final ColorSchemeAssociationKind HIGHLIGHT_TEXT = new ColorSchemeAssociationKind("highlightText", HIGHLIGHT);
        public static final ColorSchemeAssociationKind HIGHLIGHT_BORDER = new ColorSchemeAssociationKind("highlightBorder", BORDER);
        public static final ColorSchemeAssociationKind HIGHLIGHT_MARK = new ColorSchemeAssociationKind("highlightMark", MARK);

        public ColorSchemeAssociationKind(String name, ColorSchemeAssociationKind fallback) {
            this.name = name;
            this.fallback = fallback;
            values.add(this);
        }

        public String toString() {
            return this.name;
        }

        public static Set<ColorSchemeAssociationKind> values() {
            return Collections.unmodifiableSet(values);
        }

        public ColorSchemeAssociationKind getFallback() {
            return this.fallback;
        }
    }

    public static enum BackgroundAppearanceStrategy {
        NEVER,
        FLAT,
        ALWAYS;

    }

    public static enum IconFilterStrategy {
        ORIGINAL,
        THEMED_FOLLOW_TEXT,
        THEMED_FOLLOW_COLOR_SCHEME;

    }

    public static enum ColorOverlayType {
        LINE,
        FOCUS_INDICATION,
        BACKGROUND_FILL,
        TEXT_BACKGROUND_FILL,
        SELECTION_BACKGROUND_FILL,
        SELECTION_FOREGROUND;

    }

    public static final class DecorationAreaType {
        private String displayName;
        public static final DecorationAreaType PRIMARY_TITLE_PANE = new DecorationAreaType("Primary title pane");
        public static final DecorationAreaType SECONDARY_TITLE_PANE = new DecorationAreaType("Secondary title pane");
        public static final DecorationAreaType TOOLBAR = new DecorationAreaType("Toolbar");
        public static final DecorationAreaType HEADER = new DecorationAreaType("Header");
        public static final DecorationAreaType FOOTER = new DecorationAreaType("Footer");
        public static final DecorationAreaType CONTROL_PANE = new DecorationAreaType("Control pane");
        public static final DecorationAreaType NONE = new DecorationAreaType("None");

        public DecorationAreaType(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static final class AnimationFacet {
        protected String displayName;
        public static final AnimationFacet ARM = new AnimationFacet("substancelaf.core.arm", true);
        public static final AnimationFacet PRESS = new AnimationFacet("substancelaf.core.press", true);
        public static final AnimationFacet FOCUS = new AnimationFacet("substancelaf.core.focus", true);
        public static final AnimationFacet FOCUS_LOOP_ANIMATION = new AnimationFacet("substancelaf.core.focusLoopAnimation", false);
        public static final AnimationFacet ROLLOVER = new AnimationFacet("substancelaf.core.rollover", true);
        public static final AnimationFacet SELECTION = new AnimationFacet("substancelaf.core.selection", true);
        public static final AnimationFacet GHOSTING_ICON_ROLLOVER = new AnimationFacet("substancelaf.core.ghosting.iconRollover", false);
        public static final AnimationFacet GHOSTING_BUTTON_PRESS = new AnimationFacet("substancelaf.core.ghosting.buttonPress", false);
        public static final AnimationFacet ICON_GLOW = new AnimationFacet("substancelaf.core.iconGlow", false);
        public static final AnimationFacet TREE_SMART_SCROLL_ANIMATION = new AnimationFacet("substancelaf.treeSmartScrollAnimation", false);

        public AnimationFacet(String displayName, boolean isDefaultAllowed) {
            this.displayName = displayName;
            if (isDefaultAllowed) {
                AnimationConfigurationManager.getInstance().allowAnimations(this);
            }
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum PasswordStrength {
        WEAK,
        MEDIUM,
        STRONG;

    }

    public static enum TitleIconHorizontalGravity {
        PLATFORM,
        NONE,
        NEXT_TO_TITLE,
        OPPOSITE_CONTROL_BUTTONS,
        SWING_DEFAULT;

    }

    public static enum VerticalGravity {
        TOP,
        CENTERED,
        BOTTOM;

    }

    public static enum HorizontalGravity {
        PLATFORM,
        LEADING,
        CENTERED,
        TRAILING,
        SWING_DEFAULT;

    }

    public static enum ButtonOrder {
        PLATFORM{

            @Override
            public boolean isDefaultButtonLeading() {
                return !LookUtils.IS_OS_MAC;
            }
        }
        ,
        DEFAULT_AS_LEADING{

            @Override
            public boolean isDefaultButtonLeading() {
                return true;
            }
        }
        ,
        DEFAULT_AS_TRAILING{

            @Override
            public boolean isDefaultButtonLeading() {
                return false;
            }
        }
        ,
        SWING_DEFAULT{

            @Override
            public boolean isDefaultButtonLeading() {
                return true;
            }
        };


        public abstract boolean isDefaultButtonLeading();
    }

    public static enum SubstanceWidgetType {
        MENU_SEARCH;

    }

    public static enum TabContentPaneBorderKind {
        DOUBLE_FULL,
        SINGLE_FULL,
        DOUBLE_PLACEMENT,
        SINGLE_PLACEMENT;

    }

    public static enum TabCloseKind {
        NONE,
        THIS,
        ALL,
        ALL_BUT_THIS;

    }

    public static enum FocusKind {
        NONE{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
            }
        }
        ,
        TEXT{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
                if (textRect == null) {
                    return;
                }
                if (textRect.width == 0 || textRect.height == 0) {
                    return;
                }
                int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                float dashLength = this.getDashLength(fontSize);
                float dashGap = this.getDashGap(fontSize);
                float dashPhase = (dashLength + dashGap) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                int delta = mainComp instanceof JComboBox || mainComp instanceof JSpinner ? 0 : 1;
                Shape contour = SubstanceOutlineUtilities.getBaseOutline(textRect.width + 2 * delta, textRect.height, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize), null);
                graphics.translate(textRect.x - delta, textRect.y);
                graphics.draw(contour);
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
                if (focusShape == null && mainComp instanceof AbstractButton && !(mainComp instanceof JCheckBox) && !(mainComp instanceof JRadioButton)) {
                    SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(mainComp);
                    if (shaper == null) {
                        return;
                    }
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                    float dashLength = this.getDashLength(fontSize);
                    float dashGap = this.getDashGap(fontSize);
                    float dashPhase = (dashLength + dashGap) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                    graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                    Shape contour = shaper.getButtonOutline((AbstractButton)mainComp, 2.0f * SubstanceSizeUtils.getBorderStrokeWidth(mainComp), mainComp.getWidth(), mainComp.getHeight(), false);
                    graphics.draw(contour);
                } else {
                    float delta = SubstanceSizeUtils.getBorderStrokeWidth(mainComp);
                    Shape contour = focusShape != null ? focusShape : SubstanceOutlineUtilities.getBaseOutline((float)mainComp.getWidth() - 2.0f * delta, (float)mainComp.getHeight() - 2.0f * delta, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(mainComp)), null);
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                    float dashLength = this.getDashLength(fontSize);
                    float dashGap = this.getDashGap(fontSize);
                    float dashPhase = (dashLength + dashGap) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                    graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                    graphics.draw(contour);
                }
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL_INNER{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
                if (focusShape == null && mainComp instanceof AbstractButton && !(mainComp instanceof JCheckBox) && !(mainComp instanceof JRadioButton)) {
                    SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(mainComp);
                    if (shaper == null) {
                        return;
                    }
                    if (shaper.isProportionate()) {
                        int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                        float dashLength = this.getDashLength(fontSize);
                        float dashGap = this.getDashGap(fontSize);
                        float dashPhase = (dashLength + dashGap) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                        graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                        float insetsPix = extraPadding;
                        Shape contour = shaper.getButtonOutline((AbstractButton)mainComp, insetsPix, mainComp.getWidth(), mainComp.getHeight(), true);
                        graphics.draw(contour);
                    }
                } else {
                    graphics.translate(extraPadding / 2.0f, extraPadding / 2.0f);
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                    Shape contour = focusShape != null ? focusShape : SubstanceOutlineUtilities.getBaseOutline((float)mainComp.getWidth() - extraPadding, (float)mainComp.getHeight() - extraPadding, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize) - extraPadding, null);
                    float dashLength = this.getDashLength(fontSize);
                    float dashGap = this.getDashGap(fontSize);
                    float dashPhase = (dashLength + dashGap) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                    graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                    graphics.draw(contour);
                }
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL_STRONG_INNER{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                graphics.setStroke(new BasicStroke(1.5f * SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1));
                if (focusShape == null && mainComp instanceof AbstractButton && !(mainComp instanceof JCheckBox) && !(mainComp instanceof JRadioButton)) {
                    SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(mainComp);
                    if (shaper == null) {
                        return;
                    }
                    if (shaper.isProportionate()) {
                        Shape contour = shaper.getButtonOutline((AbstractButton)mainComp, extraPadding, mainComp.getWidth(), mainComp.getHeight(), true);
                        graphics.draw(contour);
                    }
                } else {
                    graphics.translate(extraPadding / 2.0f, extraPadding / 2.0f);
                    Shape contour = focusShape != null ? focusShape : SubstanceOutlineUtilities.getBaseOutline((float)mainComp.getWidth() - extraPadding, (float)mainComp.getHeight() - extraPadding, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize) - extraPadding, null);
                    graphics.draw(contour);
                }
            }
        }
        ,
        UNDERLINE{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
                if (textRect == null) {
                    return;
                }
                int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                float dashLength = this.getDashLength(fontSize);
                float dashGap = this.getDashGap(fontSize);
                float dashPhase = (dashLength + dashGap) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                graphics.translate(textRect.x - 1, textRect.y);
                graphics.drawLine(0, textRect.height - 1, textRect.width, textRect.height - 1);
                graphics.dispose();
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        STRONG_UNDERLINE{

            @Override
            public void paintFocus(Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Graphics2D graphics, Shape focusShape, Rectangle textRect, float extraPadding) {
                if (textRect == null) {
                    return;
                }
                graphics.setStroke(new BasicStroke(1.5f * SubstanceSizeUtils.getFocusStrokeWidth(mainComp), 0, 1));
                graphics.translate(textRect.x - 1, textRect.y);
                graphics.drawLine(0, textRect.height - 1, textRect.width, textRect.height - 1);
            }
        };


        public abstract void paintFocus(Component var1, Component var2, TransitionAwareUI var3, Graphics2D var4, Shape var5, Rectangle var6, float var7);

        protected final float getDashLength(int fontSize) {
            return 2.0f + (float)SubstanceSizeUtils.getExtraPadding(fontSize);
        }

        protected final float getDashGap(int fontSize) {
            return this.getDashLength(fontSize) / 2.0f;
        }

        public boolean isAnimated() {
            return false;
        }
    }

    public static enum Side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }

    @FunctionalInterface
    public static interface LocaleChangeListener {
        public void localeChanged();
    }
}

