/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceIconFactory {
    private static LazyResettableHashMap<Icon> sliderHorizontalIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderHorizontalIcon");
    private static LazyResettableHashMap<Icon> sliderRoundIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderRoundIcon");
    private static LazyResettableHashMap<Icon> sliderVerticalIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderVerticalIcon");
    private static LazyResettableHashMap<ResizableIcon> treeIcons = new LazyResettableHashMap("SubstanceIconFactory.treeIcon");
    private static final Map<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>> titlePaneIcons = SubstanceIconFactory.createTitlePaneIcons();

    public static Icon getSliderHorizontalIcon(JSlider slider, int size, boolean isMirrored) {
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(NeonCortex.getScaleFactor((Component)slider), size, isMirrored);
        if (sliderHorizontalIcons.get(key) == null) {
            SliderHorizontalIcon icon = new SliderHorizontalIcon(size, isMirrored);
            sliderHorizontalIcons.put(key, icon);
        }
        return sliderHorizontalIcons.get(key);
    }

    public static Icon getSliderRoundIcon(JSlider slider, int size) {
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(NeonCortex.getScaleFactor((Component)slider), size);
        if (sliderRoundIcons.get(key) == null) {
            SliderRoundIcon icon = new SliderRoundIcon(size);
            sliderRoundIcons.put(key, icon);
        }
        return sliderRoundIcons.get(key);
    }

    public static Icon getSliderVerticalIcon(JSlider slider, int size, boolean isMirrorred) {
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(NeonCortex.getScaleFactor((Component)slider), size, isMirrorred);
        if (sliderVerticalIcons.get(key) == null) {
            SliderVerticalIcon icon = new SliderVerticalIcon(size, isMirrorred);
            sliderVerticalIcons.put(key, icon);
        }
        return sliderVerticalIcons.get(key);
    }

    public static ResizableIcon getTreeIcon(JTree tree, boolean isCollapsed) {
        double scale = NeonCortex.getScaleFactor((Component)tree);
        int fontSize = SubstanceSizeUtils.getComponentFontSize(tree);
        int size = SubstanceSizeUtils.getTreeIconSize(fontSize);
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, size, isCollapsed);
        if (treeIcons.get(key) == null) {
            TreeIcon icon = new TreeIcon(size, isCollapsed);
            treeIcons.put(key, icon);
        }
        return treeIcons.get(key);
    }

    private static Map<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>> createTitlePaneIcons() {
        HashMap<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>> result = new HashMap<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>>();
        result.put(IconKind.CLOSE, new LazyResettableHashMap("Close title pane icons"));
        result.put(IconKind.MINIMIZE, new LazyResettableHashMap("Minimize title pane icons"));
        result.put(IconKind.MAXIMIZE, new LazyResettableHashMap("Maximize title pane icons"));
        result.put(IconKind.RESTORE, new LazyResettableHashMap("Restore title pane icons"));
        return result;
    }

    public static ScaleAwareImageWrapperIcon getTitlePaneIcon(Component titlePane, IconKind iconKind, SubstanceColorScheme scheme) {
        LazyResettableHashMap<ScaleAwareImageWrapperIcon> kindMap = titlePaneIcons.get((Object)iconKind);
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(NeonCortex.getScaleFactor((Component)titlePane), scheme.getDisplayName());
        ScaleAwareImageWrapperIcon result = kindMap.get(key);
        if (result != null) {
            return result;
        }
        switch (iconKind) {
            case CLOSE: {
                result = SubstanceImageCreator.getCloseIcon(titlePane, scheme);
                break;
            }
            case MINIMIZE: {
                result = SubstanceImageCreator.getMinimizeIcon(titlePane, scheme);
                break;
            }
            case MAXIMIZE: {
                result = SubstanceImageCreator.getMaximizeIcon(titlePane, scheme);
                break;
            }
            case RESTORE: {
                result = SubstanceImageCreator.getRestoreIcon(titlePane, scheme);
            }
        }
        kindMap.put(key, result);
        return result;
    }

    public static enum IconKind {
        CLOSE,
        MINIMIZE,
        MAXIMIZE,
        RESTORE;

    }

    private static class TreeIcon
    implements ResizableIcon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("SubstanceIconFactory.TreeIcon");
        private boolean isCollapsed;
        private int size;

        public TreeIcon(int size, boolean isCollapsed) {
            this.isCollapsed = isCollapsed;
            this.size = size;
        }

        public void setDimension(Dimension newDimension) {
            this.size = newDimension.width;
        }

        private static ScaleAwareImageWrapperIcon getIcon(JTree tree, boolean isCollapsed) {
            double scale = NeonCortex.getScaleFactor((Component)tree);
            ComponentState state = tree == null || tree.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(tree, state);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(tree, SubstanceSlices.ColorSchemeAssociationKind.BORDER, state);
            SubstanceColorScheme markScheme = SubstanceColorSchemeUtilities.getColorScheme(tree, SubstanceSlices.ColorSchemeAssociationKind.MARK, state);
            int fontSize = SubstanceSizeUtils.getComponentFontSize(tree);
            ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, fontSize, fillScheme.getDisplayName(), borderScheme.getDisplayName(), markScheme.getDisplayName(), isCollapsed);
            ScaleAwareImageWrapperIcon result = icons.get(key);
            if (result != null) {
                return result;
            }
            result = new ScaleAwareImageWrapperIcon(SubstanceImageCreator.getTreeIcon(tree, fillScheme, borderScheme, markScheme, isCollapsed), scale);
            icons.put(key, result);
            return result;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JTree tree = c instanceof JTree ? (JTree)c : null;
            ScaleAwareImageWrapperIcon iconToDraw = TreeIcon.getIcon(tree, this.isCollapsed);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g2d, 0, 0);
            g2d.dispose();
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderVerticalIcon");
        private int size;
        private boolean isMirrorred;

        public SliderVerticalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private ScaleAwareImageWrapperIcon getIcon(JSlider slider, StateTransitionTracker stateTransitionTracker) {
            double scale = NeonCortex.getScaleFactor((Component)slider);
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float activeStrength = stateTransitionTracker.getActiveStrength();
            int height = (int)((double)this.size * (2.0 + (double)activeStrength) / 3.0);
            height = Math.min(height, this.size - 2);
            int delta = (this.size - height) / 2 - 1;
            SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(slider);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(slider);
            SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, currState);
            SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
            ImageHashMapKey baseKey = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.size, height, slider.getComponentOrientation(), baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
            ScaleAwareImageWrapperIcon baseLayer = icons.get(baseKey);
            if (baseLayer == null) {
                baseLayer = this.getSingleLayer(slider, height, delta, fillPainter, borderPainter, baseFillScheme, baseBorderScheme);
                icons.put(baseKey, baseLayer);
            }
            if (currState.isDisabled() || activeStates.size() == 1) {
                return baseLayer;
            }
            BufferedImage result = SubstanceCoreUtilities.getBlankImage(scale, baseLayer.getIconWidth(), baseLayer.getIconHeight());
            Graphics2D g2d = result.createGraphics();
            baseLayer.paintIcon(slider, g2d, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
                ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.size, height, slider.getComponentOrientation(), fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
                ScaleAwareImageWrapperIcon layer = icons.get(key);
                if (layer == null) {
                    layer = this.getSingleLayer(slider, height, delta, fillPainter, borderPainter, fillScheme, borderScheme);
                    icons.put(key, layer);
                }
                g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
                layer.paintIcon(slider, g2d, 0, 0);
            }
            g2d.dispose();
            return new ScaleAwareImageWrapperIcon(result, scale);
        }

        private ScaleAwareImageWrapperIcon getSingleLayer(JSlider slider, int height, int delta, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme) {
            double scale = NeonCortex.getScaleFactor((Component)slider);
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth(slider) / 2.0f;
            GeneralPath contour = SubstanceOutlineUtilities.getTriangleButtonOutline(height, this.size - 1, 2.0f, borderDelta);
            BufferedImage stateImage = SubstanceCoreUtilities.getBlankImage(scale, this.size - 1, this.size - 1);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(delta, 0);
            fillPainter.paintContourBackground(g2d, slider, height, this.size, contour, false, fillScheme, true);
            float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth(slider);
            GeneralPath contourInner = SubstanceOutlineUtilities.getTriangleButtonOutline(height, this.size - 1, 2.0f, borderThickness + borderDelta);
            borderPainter.paintBorder(g2d, slider, height, this.size - 1, contour, contourInner, borderScheme);
            stateImage = this.isMirrorred ? SubstanceImageCreator.getRotated(scale, stateImage, 1) : SubstanceImageCreator.getRotated(scale, stateImage, 3);
            if (!slider.getComponentOrientation().isLeftToRight()) {
                stateImage = SubstanceImageCreator.getRotated(scale, stateImage, 2);
            }
            return new ScaleAwareImageWrapperIcon(stateImage, scale);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)slider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            ScaleAwareImageWrapperIcon iconToDraw = this.getIcon(slider, stateTransitionTracker);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderRoundIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderRoundIcon");
        private int size;

        public SliderRoundIcon(int size) {
            this.size = size;
        }

        private ScaleAwareImageWrapperIcon getIcon(JSlider slider, StateTransitionTracker stateTransitionTracker) {
            double scale = NeonCortex.getScaleFactor((Component)slider);
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float activeStrength = stateTransitionTracker.getActiveStrength();
            float width = (float)this.size * (2.0f + activeStrength) / 3.0f;
            SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(slider);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(slider);
            SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, currState);
            SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
            ImageHashMapKey baseKey = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName());
            ScaleAwareImageWrapperIcon baseLayer = icons.get(baseKey);
            if (baseLayer == null) {
                baseLayer = this.getSingleLayer(slider, width, fillPainter, borderPainter, baseFillScheme, baseBorderScheme);
                icons.put(baseKey, baseLayer);
            }
            if (currState.isDisabled() || activeStates.size() == 1) {
                return baseLayer;
            }
            BufferedImage result = SubstanceCoreUtilities.getBlankImage(scale, baseLayer.getIconWidth(), baseLayer.getIconHeight());
            Graphics2D g2d = result.createGraphics();
            baseLayer.paintIcon(slider, g2d, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
                ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName());
                ScaleAwareImageWrapperIcon layer = icons.get(key);
                if (layer == null) {
                    layer = this.getSingleLayer(slider, width, fillPainter, borderPainter, fillScheme, borderScheme);
                    icons.put(key, layer);
                }
                g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
                layer.paintIcon(slider, g2d, 0, 0);
            }
            g2d.dispose();
            return new ScaleAwareImageWrapperIcon(result, scale);
        }

        private ScaleAwareImageWrapperIcon getSingleLayer(JSlider slider, float width, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme) {
            double scale = NeonCortex.getScaleFactor((Component)slider);
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth(slider) / 2.0f;
            Ellipse2D.Float contour = new Ellipse2D.Float(borderDelta, borderDelta, width - 2.0f * borderDelta - 1.0f, width - 2.0f * borderDelta - 1.0f);
            BufferedImage stateImage = SubstanceCoreUtilities.getBlankImage(scale, this.size, this.size);
            Graphics2D g2d = stateImage.createGraphics();
            float delta = ((float)this.size - width) / 2.0f;
            g2d.translate(delta, delta);
            fillPainter.paintContourBackground(g2d, slider, width, this.size, contour, false, fillScheme, true);
            float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth(slider);
            Ellipse2D.Float contourInner = new Ellipse2D.Float(borderDelta + borderThickness, borderDelta + borderThickness, width - 2.0f * borderDelta - 2.0f * borderThickness - 1.0f, width - 2.0f * borderDelta - 2.0f * borderThickness - 1.0f);
            borderPainter.paintBorder(g2d, slider, width, this.size, contour, contourInner, borderScheme);
            return new ScaleAwareImageWrapperIcon(stateImage, scale);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)slider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            ScaleAwareImageWrapperIcon iconToDraw = this.getIcon(slider, stateTransitionTracker);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderHorizontalIcon");
        private int size;
        private boolean isMirrorred;

        public SliderHorizontalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private ScaleAwareImageWrapperIcon getIcon(JSlider slider, StateTransitionTracker stateTransitionTracker) {
            double scale = NeonCortex.getScaleFactor((Component)slider);
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float activeStrength = stateTransitionTracker.getActiveStrength();
            float width = (float)this.size * (2.0f + activeStrength) / 3.0f;
            SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(slider);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(slider);
            SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, currState);
            SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
            ImageHashMapKey baseKey = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
            ScaleAwareImageWrapperIcon baseLayer = icons.get(baseKey);
            if (baseLayer == null) {
                baseLayer = this.getSingleLayer(slider, width, fillPainter, borderPainter, baseFillScheme, baseBorderScheme);
                icons.put(baseKey, baseLayer);
            }
            if (currState.isDisabled() || activeStates.size() == 1) {
                return baseLayer;
            }
            BufferedImage result = SubstanceCoreUtilities.getBlankImage(scale, baseLayer.getIconWidth(), baseLayer.getIconHeight());
            Graphics2D g2d = result.createGraphics();
            baseLayer.paintIcon(slider, g2d, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
                ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
                ScaleAwareImageWrapperIcon layer = icons.get(key);
                if (layer == null) {
                    layer = this.getSingleLayer(slider, width, fillPainter, borderPainter, fillScheme, borderScheme);
                    icons.put(key, layer);
                }
                g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
                layer.paintIcon(slider, g2d, 0, 0);
            }
            g2d.dispose();
            return new ScaleAwareImageWrapperIcon(result, scale);
        }

        private ScaleAwareImageWrapperIcon getSingleLayer(JSlider slider, float width, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme) {
            double scale = NeonCortex.getScaleFactor((Component)slider);
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth(slider) / 2.0f;
            GeneralPath contour = SubstanceOutlineUtilities.getTriangleButtonOutline(width, this.size - 1, 2.0f, borderDelta);
            BufferedImage stateImage = SubstanceCoreUtilities.getBlankImage(scale, this.size, this.size);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(((float)this.size - width) / 2.0f, 0.0);
            fillPainter.paintContourBackground(g2d, slider, width, this.size, contour, false, fillScheme, true);
            float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth(slider);
            GeneralPath contourInner = SubstanceOutlineUtilities.getTriangleButtonOutline(width, this.size - 1, 2.0f, borderThickness + borderDelta);
            borderPainter.paintBorder(g2d, slider, width, this.size, contour, contourInner, borderScheme);
            g2d.dispose();
            if (this.isMirrorred) {
                stateImage = SubstanceImageCreator.getRotated(scale, stateImage, 2);
            }
            return new ScaleAwareImageWrapperIcon(stateImage, scale);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)slider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            ScaleAwareImageWrapperIcon iconToDraw = this.getIcon(slider, stateTransitionTracker);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

