/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class ScaleAwareImageWrapperIcon
implements ResizableIcon,
UIResource {
    private final double scale;
    private BufferedImage imageSource;
    private int width;
    private int height;

    public ScaleAwareImageWrapperIcon(BufferedImage image, double scale) {
        this.imageSource = image;
        this.scale = scale;
        this.width = this.getInternalWidth();
        this.height = this.getInternalHeight();
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        int dx = (this.width - this.getInternalWidth()) / 2;
        int dy = (this.height - this.getInternalHeight()) / 2;
        g2d.translate(x + dx, y + dy);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.drawImage(this.imageSource, 0, 0, (int)((double)this.imageSource.getWidth() / this.scale), (int)((double)this.imageSource.getHeight() / this.scale), null);
        g2d.dispose();
    }

    private int getInternalWidth() {
        return (int)((double)this.imageSource.getWidth() / this.scale);
    }

    public int getIconWidth() {
        return this.width;
    }

    private int getInternalHeight() {
        return (int)((double)this.imageSource.getHeight() / this.scale);
    }

    public int getIconHeight() {
        return this.height;
    }
}

