/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconPack;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;

public class SubstanceOptionPaneUI
extends BasicOptionPaneUI {
    private static final int ICON_SIZE = 36;
    private OptionPaneLabel substanceIconLabel;
    private IconGlowTracker iconGlowTracker;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceOptionPaneUI();
    }

    private SubstanceOptionPaneUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
    }

    @Override
    protected void addIcon(Container top) {
        Icon sideIcon;
        Icon icon = sideIcon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (sideIcon == null && this.optionPane != null) {
            sideIcon = this.getIconForType(this.optionPane.getMessageType());
        }
        if (sideIcon != null) {
            this.substanceIconLabel = new OptionPaneLabel();
            this.substanceIconLabel.setOpaque(false);
            this.iconGlowTracker = new IconGlowTracker(this.substanceIconLabel);
            GlowingIcon glowingIcon = new GlowingIcon(sideIcon, this.iconGlowTracker);
            glowingIcon.setDampeningFactor(10.0f);
            this.substanceIconLabel.setIcon(glowingIcon);
            this.substanceIconLabel.setBorder(new EmptyBorder(0, 8, 0, 8));
            this.substanceIconLabel.setName("OptionPane.iconLabel");
            this.substanceIconLabel.setVerticalAlignment(1);
            top.add((Component)this.substanceIconLabel, "Before");
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        SubstanceIconPack iconPack = SubstanceCortex.GlobalScope.getIconPack();
        int size = (int)SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getControlFontSize(), 36.0f, 3, 2.0f);
        SubstanceColorScheme colorScheme = SubstanceCortex.GlobalScope.getCurrentSkin().getOptionPaneIconColorScheme(messageType);
        switch (messageType) {
            case 0: {
                return iconPack.getOptionPaneErrorIcon(size, colorScheme);
            }
            case 1: {
                return iconPack.getOptionPaneInformationIcon(size, colorScheme);
            }
            case 2: {
                return iconPack.getOptionPaneWarningIcon(size, colorScheme);
            }
            case 3: {
                return iconPack.getOptionPaneQuestionIcon(size, colorScheme);
            }
        }
        return null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        if (this.substanceIconLabel != null && !this.iconGlowTracker.isPlaying()) {
            this.iconGlowTracker.play(3);
        }
    }

    @Override
    protected Container createButtonArea() {
        JPanel bottom = new JPanel();
        bottom.setName("OptionPane.buttonArea");
        bottom.setLayout(new SubstanceFooterLayout(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(bottom), 8, 4, 1, true), SubstanceCortex.GlobalScope.getButtonBarOrder().isDefaultButtonLeading()));
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        return bottom;
    }

    static {
        AnimationConfigurationManager.getInstance().allowAnimations(SubstanceSlices.AnimationFacet.ICON_GLOW, OptionPaneLabel.class);
    }

    private static class SubstanceFooterLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        private int padding;
        private boolean isDefaultButtonLeading;

        private SubstanceFooterLayout(int padding, boolean isDefaultButtonLeading) {
            super(true, padding);
            this.padding = padding;
            this.isDefaultButtonLeading = isDefaultButtonLeading;
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        private Dimension getMaxButtonSize(Container container) {
            Component[] children = container.getComponents();
            Dimension result = new Dimension(0, 0);
            for (Component child : children) {
                Dimension pref = child.getPreferredSize();
                result.width = Math.max(result.width, pref.width);
                result.height = Math.max(result.height, pref.height);
            }
            return result;
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int x;
                int numChildren = children.length;
                Insets insets = container.getInsets();
                Dimension maxDimension = this.getMaxButtonSize(container);
                int totalButtonWidth = maxDimension.width * numChildren + this.padding * (numChildren - 1);
                boolean isLeftToRight = container.getComponentOrientation().isLeftToRight();
                int buttonAlignment = SubstanceCoreUtilities.getButtonBarGravity(container);
                switch (buttonAlignment) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 0: {
                        x = (container.getWidth() - insets.left - insets.right - totalButtonWidth) / 2;
                        break;
                    }
                    default: {
                        x = container.getWidth() - insets.right - totalButtonWidth;
                    }
                }
                boolean iterateForward = isLeftToRight == this.isDefaultButtonLeading;
                for (int counter = 0; counter < numChildren; ++counter) {
                    int index = iterateForward ? counter : numChildren - counter - 1;
                    children[index].setBounds(x, insets.top, maxDimension.width, maxDimension.height);
                    x += children[index].getWidth() + this.padding;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (container == null) {
                return new Dimension(0, 0);
            }
            Component[] children = container.getComponents();
            if (children == null || children.length == 0) {
                return new Dimension(0, 0);
            }
            int numChildren = children.length;
            Insets insets = container.getInsets();
            Dimension maxDimension = this.getMaxButtonSize(container);
            return new Dimension(insets.left + insets.right + maxDimension.width * numChildren + this.padding * (numChildren - 1), insets.top + insets.bottom + maxDimension.height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    private static class OptionPaneLabel
    extends JLabel {
        private OptionPaneLabel() {
        }
    }
}

