/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.ThemedIconAwareRenderer;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    private PropertyChangeListener substancePropertyChangeListener;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceLabelUI();
    }

    private SubstanceLabelUI() {
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = propertyChangeEvent -> {
            if ("opaque".equals(propertyChangeEvent.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("substancelaf.internal.lockopacity"))) {
                c.putClientProperty("substancelaf.internal.controlopacityoriginal", propertyChangeEvent.getNewValue());
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        float rolloverAmount = 0.0f;
        SubstanceSlices.IconThemingStrategy iconThemingStrategy = SubstanceCoreUtilities.getIconThemingType(label);
        Insets insets = label.getInsets(this.paintViewInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        g.setFont(label.getFont());
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, label.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        BackgroundPaintingUtils.updateIfOpaque(g2d, c);
        ComponentState labelState = label.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float labelAlpha = SubstanceColorSchemeUtilities.getAlpha(label, labelState);
        Color textColor = null;
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.paintTextR);
            } else if (label.getClientProperty("substancelaf.internal.isTitlePaneLabel") == Boolean.TRUE) {
                SubstanceSkin skin = SubstanceCoreUtilities.getSkin(label.getRootPane());
                SubstanceColorScheme scheme = skin.getEnabledColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
                FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(NeonCortex.getScaleFactor((Component)label), label.getFont());
                int yOffset = this.paintTextR.y + (int)((this.paintTextR.getHeight() - (double)fm.getHeight()) / 2.0) + fm.getAscent();
                g2d.translate(this.paintTextR.x + 3, 0);
                textColor = scheme.getForegroundColor();
                SubstanceTextUtilities.paintTextWithDropShadow(label, g2d, textColor, scheme.getEchoColor(), clippedText, this.paintTextR.width + 6, this.paintTextR.height, 0, yOffset);
                g2d.translate(-this.paintTextR.x - 3, 0);
            } else {
                textColor = SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)label, this.paintTextR, clippedText, label.getDisplayedMnemonicIndex(), labelState, labelAlpha);
            }
        }
        ScaleAwareImageWrapperIcon themedIcon = null;
        if (label.isEnabled() && icon != null && iconThemingStrategy != null) {
            if (label instanceof ThemedIconAwareRenderer) {
                ThemedIconAwareRenderer themedIconAwareRenderer = (ThemedIconAwareRenderer)((Object)label);
                rolloverAmount = themedIconAwareRenderer.getRolloverArmAmount();
            }
            themedIcon = SubstanceCoreUtilities.getThemedIcon(c, icon, textColor);
        }
        if (icon != null) {
            g2d.translate(this.paintIconR.x, this.paintIconR.y);
            if (themedIcon != null) {
                themedIcon.paintIcon(c, g2d, 0, 0);
                if (rolloverAmount > 0.0f && iconThemingStrategy != null && iconThemingStrategy.isForInactiveState() && icon != themedIcon) {
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(c, rolloverAmount, g));
                    icon.paintIcon(c, g2d, 0, 0);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
                }
            } else {
                icon.paintIcon(c, g2d, 0, 0);
            }
            g2d.translate(-this.paintIconR.x, -this.paintIconR.y);
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension result = SubstanceMetricsUtilities.getPreferredLabelSize((JLabel)c);
        if (c.getClientProperty("substancelaf.internal.isTitlePaneLabel") == Boolean.TRUE) {
            result.width += 6;
            result.height += 6;
        }
        return result;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }
}

