/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.ColorTransform;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class MarinerSkin
extends SubstanceSkin {
    public static final String NAME = "Mariner";
    private BottomLineOverlayPainter menuOverlayPainter;
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public MarinerSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/mariner.colorschemes"));
        SubstanceColorScheme activeScheme = schemes.get("Mariner Active");
        SubstanceColorScheme enabledScheme = schemes.get("Mariner Enabled");
        SubstanceColorScheme disabledScheme = schemes.get("Mariner Disabled");
        SubstanceColorScheme disabledSelectedScheme = schemes.get("Mariner Disabled Selected");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerAlpha(0.8f, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerAlpha(0.8f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(disabledSelectedScheme, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme activeBorderScheme = schemes.get("Mariner Active Border");
        SubstanceColorScheme enabledBorderScheme = schemes.get("Mariner Enabled Border");
        SubstanceColorScheme disabledSelectedBorderScheme = schemes.get("Mariner Disabled Selected Border");
        defaultSchemeBundle.registerColorScheme(activeBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(disabledSelectedBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(enabledBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme activeMarkScheme = schemes.get("Mariner Active Mark");
        SubstanceColorScheme enabledMarkScheme = schemes.get("Mariner Enabled Mark");
        defaultSchemeBundle.registerColorScheme(activeMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(enabledMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ENABLED);
        ComponentState uneditableState = new ComponentState("uneditable", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.EDITABLE});
        SubstanceColorScheme uneditableControls = schemes.get("Mariner Uneditable");
        defaultSchemeBundle.registerColorScheme(uneditableControls, SubstanceSlices.ColorSchemeAssociationKind.FILL, uneditableState);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme headerColorScheme = schemes.get("Mariner Header");
        SubstanceColorScheme headerBorderColorScheme = schemes.get("Mariner Header Border");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(headerColorScheme, headerColorScheme, headerColorScheme);
        headerSchemeBundle.registerAlpha(0.4f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(headerColorScheme, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(headerColorScheme, ComponentState.ROLLOVER_UNSELECTED);
        headerSchemeBundle.registerColorScheme(activeScheme, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ROLLOVER_SELECTED);
        headerSchemeBundle.registerColorScheme(headerColorScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(headerBorderColorScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(enabledMarkScheme.shade(0.8f), SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.PRESSED_SELECTED);
        headerSchemeBundle.registerColorScheme(enabledMarkScheme.shade(0.7f), SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ROLLOVER_UNSELECTED);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerColorScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        SubstanceColorScheme enabledFooterScheme = schemes.get("Mariner Footer Enabled");
        SubstanceColorScheme disabledFooterScheme = schemes.get("Mariner Footer Disabled");
        SubstanceColorSchemeBundle footerSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledFooterScheme, disabledFooterScheme);
        footerSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED);
        footerSchemeBundle.registerAlpha(0.8f, ComponentState.DISABLED_UNSELECTED);
        footerSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        footerSchemeBundle.registerColorScheme(disabledFooterScheme, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme footerEnabledBorderScheme = schemes.get("Mariner Footer Enabled Border");
        footerSchemeBundle.registerColorScheme(activeBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        footerSchemeBundle.registerColorScheme(activeBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        footerSchemeBundle.registerColorScheme(footerEnabledBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme footerEnabledMarkScheme = schemes.get("Mariner Footer Enabled Mark");
        footerSchemeBundle.registerColorScheme(activeMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        footerSchemeBundle.registerColorScheme(footerEnabledMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ENABLED);
        SubstanceColorScheme footerSeparatorScheme = schemes.get("Mariner Footer Separator");
        footerSchemeBundle.registerColorScheme(footerSeparatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme footerBackgroundColorScheme = schemes.get("Mariner Footer Background");
        this.registerDecorationAreaSchemeBundle(footerSchemeBundle, footerBackgroundColorScheme, SubstanceSlices.DecorationAreaType.FOOTER, SubstanceSlices.DecorationAreaType.TOOLBAR, SubstanceSlices.DecorationAreaType.CONTROL_PANE);
        this.setTabFadeStart(0.15);
        this.setTabFadeEnd(0.25);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.LIGHT);
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, SubstanceSlices.DecorationAreaType.FOOTER);
        this.menuOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.ULTRADARK, ColorTransform.brightness(-0.5f)));
        this.addOverlayPainter(this.menuOverlayPainter, SubstanceSlices.DecorationAreaType.HEADER);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(100), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK);
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new FractionBasedBorderPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.MID});
        this.highlightBorderPainter = new ClassicBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

