/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.ColorTransform;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateFractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class GeminiSkin
extends SubstanceSkin {
    public static final String NAME = "Gemini";
    private BottomLineOverlayPainter menuOverlayPainter;
    private TopLineOverlayPainter toolbarOverlayPainter;
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public GeminiSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/gemini.colorschemes"));
        SubstanceColorScheme grayScheme = schemes.get("Gemini Gray");
        SubstanceColorScheme disabledScheme = schemes.get("Gemini Disabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(grayScheme, grayScheme, disabledScheme);
        SubstanceColorScheme highlightScheme = schemes.get("Gemini Highlight");
        SubstanceColorScheme highlightBorderScheme = schemes.get("Gemini Highlight Border");
        GeminiSkin.applyHighlightColorScheme(defaultSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(defaultSchemeBundle, highlightScheme, highlightBorderScheme);
        SubstanceColorScheme grayBorderScheme = schemes.get("Gemini Gray Border");
        SubstanceColorScheme lightGrayBorderScheme = schemes.get("Gemini Light Gray Border");
        SubstanceColorScheme darkGraySeparatorScheme = schemes.get("Gemini Dark Gray Separator");
        defaultSchemeBundle.registerColorScheme(grayBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(lightGrayBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_DEFAULT, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(grayScheme, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(darkGraySeparatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(grayScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        defaultSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(highlightScheme.tone(0.2f), ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme whiteBackgroundScheme = schemes.get("Gemini White Background");
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, whiteBackgroundScheme, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorSchemeBundle controlPaneSchemeBundle = new SubstanceColorSchemeBundle(grayScheme, grayScheme, disabledScheme);
        controlPaneSchemeBundle.registerColorScheme(grayScheme, ComponentState.ROLLOVER_UNSELECTED);
        controlPaneSchemeBundle.registerColorScheme(grayScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        controlPaneSchemeBundle.registerColorScheme(grayBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        controlPaneSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        GeminiSkin.applyHighlightColorScheme(controlPaneSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(controlPaneSchemeBundle, highlightScheme, highlightBorderScheme);
        this.registerDecorationAreaSchemeBundle(controlPaneSchemeBundle, grayScheme, SubstanceSlices.DecorationAreaType.CONTROL_PANE, SubstanceSlices.DecorationAreaType.FOOTER);
        SubstanceColorScheme blackColorScheme = schemes.get("Gemini Black");
        SubstanceColorScheme activeHeaderScheme = schemes.get("Gemini Black Active Header");
        SubstanceColorScheme disabledHeaderScheme = schemes.get("Gemini Black Disabled Header");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeHeaderScheme, blackColorScheme, blackColorScheme);
        headerSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(disabledHeaderScheme, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(blackColorScheme, ComponentState.ROLLOVER_UNSELECTED);
        headerSchemeBundle.registerColorScheme(blackColorScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(grayScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        headerSchemeBundle.registerColorScheme(blackColorScheme.shade(0.9f), SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        GeminiSkin.applyHighlightColorScheme(headerSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(headerSchemeBundle, highlightScheme, highlightBorderScheme);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, blackColorScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        SubstanceColorScheme darkBlueColorScheme = schemes.get("Gemini Dark Blue");
        SubstanceColorScheme darkBlueBackgroundColorScheme = schemes.get("Gemini Dark Blue Background");
        SubstanceColorScheme darkBlueSeparatorColorScheme = schemes.get("Gemini Dark Blue Separator");
        SubstanceColorSchemeBundle toolbarSchemeBundle = new SubstanceColorSchemeBundle(blackColorScheme, darkBlueColorScheme, darkBlueColorScheme);
        toolbarSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        toolbarSchemeBundle.registerColorScheme(blackColorScheme, ComponentState.DISABLED_SELECTED);
        toolbarSchemeBundle.registerColorScheme(darkBlueColorScheme, ComponentState.DISABLED_UNSELECTED);
        toolbarSchemeBundle.registerColorScheme(blackColorScheme, ComponentState.ROLLOVER_UNSELECTED);
        toolbarSchemeBundle.registerColorScheme(darkBlueColorScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        toolbarSchemeBundle.registerColorScheme(darkBlueColorScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        toolbarSchemeBundle.registerColorScheme(darkBlueSeparatorColorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        toolbarSchemeBundle.registerColorScheme(highlightScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.PRESSED_SELECTED);
        GeminiSkin.applyHighlightColorScheme(toolbarSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(toolbarSchemeBundle, highlightScheme, darkBlueColorScheme);
        this.registerDecorationAreaSchemeBundle(toolbarSchemeBundle, darkBlueBackgroundColorScheme, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.setTabFadeStart(0.15);
        this.setTabFadeEnd(0.25);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.ULTRALIGHT);
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, SubstanceSlices.DecorationAreaType.FOOTER);
        this.menuOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.ULTRADARK, ColorTransform.brightness(-0.5f)));
        this.toolbarOverlayPainter = new TopLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.FOREGROUND, ColorTransform.alpha(32)));
        this.addOverlayPainter(this.menuOverlayPainter, SubstanceSlices.DecorationAreaType.HEADER);
        this.addOverlayPainter(this.toolbarOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(100), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK);
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        FractionBasedBorderPainter outerBorderPainter = new FractionBasedBorderPainter("Gemini Outer", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.ULTRADARK});
        DelegateFractionBasedBorderPainter innerBorderPainter = new DelegateFractionBasedBorderPainter("Gemini Inner", outerBorderPainter, new int[]{0x60FFFFFF, 0x40FFFFFF, 0x20FFFFFF}, scheme -> scheme.tint(0.7f));
        this.borderPainter = new CompositeBorderPainter(NAME, outerBorderPainter, innerBorderPainter);
        this.highlightBorderPainter = new ClassicBorderPainter();
    }

    private static void applyHighlightColorScheme(SubstanceColorSchemeBundle schemeBundle, SubstanceColorScheme highlightScheme) {
        schemeBundle.registerHighlightAlpha(0.85f, ComponentState.ROLLOVER_UNSELECTED);
        schemeBundle.registerHighlightAlpha(0.9f, ComponentState.SELECTED);
        schemeBundle.registerHighlightAlpha(1.0f, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        schemeBundle.registerHighlightColorScheme(highlightScheme, ComponentState.ROLLOVER_UNSELECTED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
    }

    private static void applyHighlightAsFill(SubstanceColorSchemeBundle schemeBundle, SubstanceColorScheme highlightScheme, SubstanceColorScheme highlightBorderScheme) {
        schemeBundle.registerColorScheme(highlightBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_ARMED, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED);
        schemeBundle.registerColorScheme(highlightScheme, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        schemeBundle.registerColorScheme(highlightScheme, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, ComponentState.getActiveStates());
        schemeBundle.registerColorScheme(highlightScheme, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        schemeBundle.registerColorScheme(highlightScheme, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

