/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JRootPane;
import org.pushingpixels.substance.api.SubstanceSlices;

public class SubstanceWidgetManager {
    private static SubstanceWidgetManager instance;
    private Set<SubstanceSlices.SubstanceWidgetType> globalAllowed = EnumSet.noneOf(SubstanceSlices.SubstanceWidgetType.class);
    private Set<SubstanceSlices.SubstanceWidgetType> globalDisallowed = EnumSet.noneOf(SubstanceSlices.SubstanceWidgetType.class);
    private WeakHashMap<JRootPane, Set<SubstanceSlices.SubstanceWidgetType>> specificAllowed = new WeakHashMap();
    private WeakHashMap<JRootPane, Set<SubstanceSlices.SubstanceWidgetType>> specificDisallowed = new WeakHashMap();

    public static synchronized SubstanceWidgetManager getInstance() {
        if (instance == null) {
            instance = new SubstanceWidgetManager();
        }
        return instance;
    }

    private SubstanceWidgetManager() {
    }

    public void register(JRootPane rootPane, boolean isAllowed, SubstanceSlices.SubstanceWidgetType ... substanceWidgets) {
        if (rootPane == null) {
            for (SubstanceSlices.SubstanceWidgetType widget : substanceWidgets) {
                if (isAllowed) {
                    this.globalAllowed.add(widget);
                    this.globalDisallowed.remove((Object)widget);
                    continue;
                }
                this.globalDisallowed.add(widget);
                this.globalAllowed.remove((Object)widget);
            }
        } else {
            Set<SubstanceSlices.SubstanceWidgetType> toAddTo = null;
            Set<SubstanceSlices.SubstanceWidgetType> toRemoveFrom = null;
            if (isAllowed) {
                toAddTo = this.specificAllowed.get(rootPane);
                if (toAddTo == null) {
                    toAddTo = EnumSet.noneOf(SubstanceSlices.SubstanceWidgetType.class);
                    this.specificAllowed.put(rootPane, toAddTo);
                }
                toRemoveFrom = this.specificDisallowed.get(rootPane);
            } else {
                toAddTo = this.specificDisallowed.get(rootPane);
                if (toAddTo == null) {
                    toAddTo = EnumSet.noneOf(SubstanceSlices.SubstanceWidgetType.class);
                    this.specificDisallowed.put(rootPane, toAddTo);
                }
                toRemoveFrom = this.specificAllowed.get(rootPane);
            }
            for (SubstanceSlices.SubstanceWidgetType widget : substanceWidgets) {
                toAddTo.add(widget);
                if (toRemoveFrom == null) continue;
                toRemoveFrom.remove((Object)widget);
            }
        }
    }

    public boolean isAllowed(JRootPane rootPane, SubstanceSlices.SubstanceWidgetType widget) {
        if (this.specificDisallowed.containsKey(rootPane) && this.specificDisallowed.get(rootPane).contains((Object)widget)) {
            return false;
        }
        if (this.specificAllowed.containsKey(rootPane) && this.specificAllowed.get(rootPane).contains((Object)widget)) {
            return true;
        }
        if (this.globalDisallowed.contains((Object)widget)) {
            return false;
        }
        return this.globalAllowed.contains((Object)widget);
    }
}

