/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorWheelImageProducer;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.HSBColorSliderModel;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class ColorWheel
extends JPanel {
    private Image colorWheelImage;
    private ColorWheelImageProducer colorWheelProducer;
    private HSBColorSliderModel model = new HSBColorSliderModel();
    private MouseHandler mouseHandler;
    private ModelHandler modelHandler;

    public ColorWheel() {
        this.initComponents();
        this.colorWheelProducer = new ColorWheelImageProducer(0, 0);
        this.mouseHandler = new MouseHandler();
        this.modelHandler = new ModelHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.setOpaque(false);
    }

    public void setModel(HSBColorSliderModel m) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelHandler);
        }
        this.model = m;
        if (this.model != null) {
            this.model.addChangeListener(this.modelHandler);
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public HSBColorSliderModel getModel() {
        return this.model;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        double scaleFactor = NeonCortex.getScaleFactor();
        if (this.colorWheelImage == null || scaleFactor * (double)this.colorWheelImage.getWidth(this) != (double)w || scaleFactor * (double)this.colorWheelImage.getHeight(this) != (double)h) {
            if (this.colorWheelImage != null) {
                this.colorWheelImage.flush();
            }
            this.colorWheelProducer = new ColorWheelImageProducer((int)((double)w * scaleFactor), (int)((double)h * scaleFactor));
            this.colorWheelImage = this.createImage(this.colorWheelProducer);
            if (scaleFactor > 1.0) {
                BufferedImage retinaWheelImage = SubstanceCoreUtilities.getBlankImage(w, h);
                Graphics2D wheel2D = retinaWheelImage.createGraphics();
                wheel2D.drawImage(this.colorWheelImage, 0, 0, w, h, null);
                wheel2D.dispose();
                this.colorWheelImage = retinaWheelImage;
            }
        }
        this.colorWheelProducer.setBrightness((float)this.model.getValue(2) / 100.0f);
        this.colorWheelProducer.regenerateColorWheel();
        g.drawImage(this.colorWheelImage, 0, 0, (int)((double)this.colorWheelImage.getWidth(null) / scaleFactor), (int)((double)this.colorWheelImage.getHeight(null) / scaleFactor), this);
        int x = w / 2 + (int)((double)(this.colorWheelProducer.getRadius() * this.model.getValue(1)) / 100.0 * Math.cos((double)this.model.getValue(0) * Math.PI / 180.0));
        int y = h / 2 - (int)((double)(this.colorWheelProducer.getRadius() * this.model.getValue(1)) / 100.0 * Math.sin((double)this.model.getValue(0) * Math.PI / 180.0));
        g.setColor(Color.white);
        g.fillRect(x - 1, y - 1, 2, 2);
        g.setColor(Color.black);
        g.drawRect(x - 2, y - 2, 3, 3);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class ModelHandler
    implements ChangeListener {
        private ModelHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorWheel.this.repaint();
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.update(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.update(e);
        }

        private void update(MouseEvent e) {
            int x = e.getX() - ColorWheel.this.getWidth() / 2;
            int y = e.getY() - ColorWheel.this.getHeight() / 2;
            float r = (float)Math.sqrt(x * x + y * y);
            float theta = (float)Math.atan2(y, -x);
            ColorWheel.this.model.setValue(0, 180 + (int)((double)theta / Math.PI * 180.0));
            ColorWheel.this.model.setValue(1, (int)(Math.min(1.0f, r / (float)ColorWheel.this.colorWheelProducer.getRadius()) * 100.0f));
            ColorWheel.this.repaint();
        }
    }
}

