/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public abstract class ImageWrapperDecorationPainter
implements SubstanceDecorationPainter {
    protected Image originalTile = null;
    protected SubstanceDecorationPainter baseDecorationPainter;
    protected LinkedHashMap<String, BufferedImage> colorizedTileMap = new LinkedHashMap<String, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
            return this.size() > 10;
        }
    };
    protected float textureAlpha = 0.2f;

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        if (decorationAreaType == SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics, comp, decorationAreaType, width, height, skin);
        } else {
            this.paintExtraBackground(graphics, comp, decorationAreaType, width, height, skin);
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        SubstanceColorScheme tileScheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (this.baseDecorationPainter == null) {
            graphics.setColor(tileScheme.getMidColor());
            graphics.fillRect(0, 0, width, height);
        } else {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, width, height, skin);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileScheme, 0, 0, width, height);
        temp.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        Point offset = SubstanceCoreUtilities.getOffsetInRootPaneCoords(comp);
        SubstanceColorScheme tileScheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (this.baseDecorationPainter != null) {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, width, height, skin);
        } else {
            graphics.setColor(tileScheme.getMidColor());
            graphics.fillRect(0, 0, width, height);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileScheme, offset.x, offset.y, width, height);
        temp.dispose();
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, Shape contour, SubstanceColorScheme colorScheme) {
        Point offset = SubstanceCoreUtilities.getOffsetInRootPaneCoords(comp);
        if (this.baseDecorationPainter != null) {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, contour, colorScheme);
        } else {
            graphics.setColor(colorScheme.getMidColor());
            graphics.fill(contour);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        temp.setClip(contour);
        this.tileArea(temp, comp, colorScheme, offset.x, offset.y, comp.getWidth(), comp.getHeight());
        temp.dispose();
    }

    private void tileArea(Graphics2D g, Component comp, SubstanceColorScheme tileScheme, int offsetTextureX, int offsetTextureY, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite(comp, this.textureAlpha, g));
        BufferedImage colorizedTile = this.getColorizedTile(tileScheme);
        float scaleFactor = (float)NeonCortex.getScaleFactor();
        int tileWidth = (int)((float)((Image)colorizedTile).getWidth(null) / scaleFactor);
        int tileHeight = (int)((float)((Image)colorizedTile).getHeight(null) / scaleFactor);
        offsetTextureX %= tileWidth;
        int currTileTop = -(offsetTextureY %= tileHeight);
        do {
            int currTileLeft = -offsetTextureX;
            do {
                graphics.drawImage(colorizedTile, currTileLeft, currTileTop, tileWidth, tileHeight, null);
            } while ((currTileLeft += tileWidth) < width);
        } while ((currTileTop += tileHeight) < height);
        graphics.dispose();
    }

    public void setBaseDecorationPainter(SubstanceDecorationPainter baseDecorationPainter) {
        this.baseDecorationPainter = baseDecorationPainter;
    }

    public void setTextureAlpha(float textureAlpha) {
        this.textureAlpha = textureAlpha;
    }

    protected BufferedImage getColorizedTile(SubstanceColorScheme scheme) {
        BufferedImage result = this.colorizedTileMap.get(scheme.getDisplayName());
        if (result == null) {
            float scaleFactor = (float)NeonCortex.getScaleFactor();
            int tileWidth = this.originalTile.getWidth(null);
            int tileHeight = this.originalTile.getHeight(null);
            BufferedImage tileBi = SubstanceCoreUtilities.getBlankImage((int)((float)tileWidth / scaleFactor), (int)((float)tileHeight / scaleFactor));
            Graphics2D tile2D = tileBi.createGraphics();
            tile2D.drawImage(this.originalTile, 0, 0, (int)((float)tileWidth / scaleFactor), (int)((float)tileHeight / scaleFactor), null);
            tile2D.dispose();
            result = SubstanceImageCreator.getColorSchemeImage(tileBi, scheme, 0.0f);
            this.colorizedTileMap.put(scheme.getDisplayName(), result);
        }
        return result;
    }
}

