/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class DerivedColorsResolverLight
implements SchemeDerivedColors {
    private SubstanceColorScheme scheme;

    public DerivedColorsResolverLight(SubstanceColorScheme scheme) {
        if (scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be light: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    public String toString() {
        return "Resolver for " + this.scheme.getDisplayName();
    }

    @Override
    public Color getLineColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getDarkColor(), 0.7f);
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getForegroundColor();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getFocusRingColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getForegroundColor(), 192);
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getUltraLightColor(), this.scheme.getExtraLightColor(), 0.8f);
    }

    @Override
    public Color getSeparatorLightColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getLightColor(), this.scheme.getDarkColor(), 0.8f);
    }

    @Override
    public Color getSeparatorDarkColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getDarkColor(), 0.4f);
    }

    @Override
    public Color getSeparatorShadowColor() {
        return this.scheme.getUltraLightColor();
    }
}

