/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

class DerivedColorsResolverDark
implements SchemeDerivedColors {
    private SubstanceColorScheme scheme;

    public DerivedColorsResolverDark(SubstanceColorScheme scheme) {
        if (!scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be dark: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    public String toString() {
        return "Resolver for " + this.scheme.getDisplayName();
    }

    @Override
    public Color getLineColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getForegroundColor();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return SubstanceColorUtilities.deriveByBrightness(this.scheme.getUltraLightColor(), 0.2f);
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getFocusRingColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getForegroundColor(), 192);
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getLightColor(), 0.4f);
    }

    @Override
    public Color getSeparatorLightColor() {
        return this.scheme.getLightColor();
    }

    @Override
    public Color getSeparatorDarkColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getSeparatorShadowColor() {
        return this.scheme.getDarkColor();
    }
}

