/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.scroll;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.painter.preview.PreviewPainter;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.widget.scroll.TweakedScrollPaneLayout;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.swing.SwingComponentTimeline;

public class ScrollPaneSelector
extends JComponent {
    private static final String COMPONENT_ORIENTATION = "componentOrientation";
    private LayoutManager theFormerLayoutManager;
    private JScrollPane theScrollPane;
    private JComponent theComponent;
    private JPopupMenu thePopupMenu;
    private boolean toRestoreOriginal;
    private JButton theButton;
    private BufferedImage theImage;
    private Rectangle theStartRectangle;
    private Rectangle theRectangle;
    private Point theStartPoint;
    private Point thePrevPoint;
    private double theScale;
    private PropertyChangeListener propertyChangeListener;
    private ContainerAdapter theViewPortViewListener;

    ScrollPaneSelector() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.theScrollPane = null;
        this.theImage = null;
        this.theStartRectangle = null;
        this.theRectangle = null;
        this.theStartPoint = null;
        this.theScale = 0.0;
        this.theButton = new JButton(){

            @Override
            public Insets getInsets() {
                return new Insets(2, 2, 2, 2);
            }

            @Override
            public Insets getInsets(Insets insets) {
                if (insets == null) {
                    insets = new Insets(2, 2, 2, 2);
                }
                insets.set(2, 2, 2, 2);
                return insets;
            }
        };
        SubstanceCoreUtilities.markButtonAsFlat(this.theButton);
        this.theButton.setFocusable(false);
        this.theButton.setFocusPainted(false);
        SubstanceCortex.ComponentScope.setButtonStraightSides(this.theButton, EnumSet.allOf(SubstanceSlices.Side.class));
        MouseInputAdapter mil = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, ScrollPaneSelector.this.theButton);
                ScrollPaneSelector.this.display(p);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ScrollPaneSelector.this.thePopupMenu.isVisible()) {
                    return;
                }
                ScrollPaneSelector.this.toRestoreOriginal = false;
                ScrollPaneSelector.this.thePopupMenu.setVisible(false);
                ScrollPaneSelector.this.theStartRectangle = ScrollPaneSelector.this.theRectangle;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ScrollPaneSelector.this.theStartPoint == null) {
                    return;
                }
                if (!ScrollPaneSelector.this.thePopupMenu.isShowing()) {
                    return;
                }
                Point newPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(newPoint, (Component)e.getSource());
                Rectangle popupScreenRect = new Rectangle(ScrollPaneSelector.this.thePopupMenu.getLocationOnScreen(), ScrollPaneSelector.this.thePopupMenu.getSize());
                if (!popupScreenRect.contains(newPoint)) {
                    return;
                }
                int deltaX = (int)((double)(newPoint.x - ((ScrollPaneSelector)ScrollPaneSelector.this).thePrevPoint.x) / ScrollPaneSelector.this.theScale);
                int deltaY = (int)((double)(newPoint.y - ((ScrollPaneSelector)ScrollPaneSelector.this).thePrevPoint.y) / ScrollPaneSelector.this.theScale);
                ScrollPaneSelector.this.scroll(deltaX, deltaY, false);
                ScrollPaneSelector.this.thePrevPoint = newPoint;
            }
        };
        this.theButton.addMouseListener(mil);
        this.theButton.addMouseMotionListener(mil);
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.thePopupMenu = new JPopupMenu();
        this.thePopupMenu.setLayout(new BorderLayout());
        this.thePopupMenu.add((Component)this, "Center");
        this.propertyChangeListener = evt -> {
            if (this.theScrollPane == null) {
                return;
            }
            if (COMPONENT_ORIENTATION.equals(evt.getPropertyName())) {
                this.theScrollPane.setCorner("LOWER_LEADING_CORNER", null);
                this.theScrollPane.setCorner("LOWER_TRAILING_CORNER", this.theButton);
            }
        };
        this.theViewPortViewListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component comp;
                if (ScrollPaneSelector.this.thePopupMenu.isVisible()) {
                    ScrollPaneSelector.this.thePopupMenu.setVisible(false);
                }
                ScrollPaneSelector.this.theComponent = (comp = ScrollPaneSelector.this.theScrollPane.getViewport().getView()) instanceof JComponent ? (JComponent)comp : null;
            }
        };
        this.thePopupMenu.addPropertyChangeListener(evt -> {
            if ("visible".equals(evt.getPropertyName()) && !this.thePopupMenu.isVisible()) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.toRestoreOriginal) {
                    int deltaX = (int)((double)(this.thePrevPoint.x - this.theStartPoint.x) / this.theScale);
                    int deltaY = (int)((double)(this.thePrevPoint.y - this.theStartPoint.y) / this.theScale);
                    this.scroll(-deltaX, -deltaY, true);
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.theImage == null || this.theRectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        double scaleFactor = NeonCortex.getScaleFactor();
        return new Dimension((int)((double)this.theImage.getWidth() / scaleFactor) + insets.left + insets.right, (int)((double)this.theImage.getHeight() / scaleFactor) + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.theImage == null || this.theRectangle == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        Insets insets = this.getInsets();
        int xOffset = insets.left;
        int yOffset = insets.top;
        int availableWidth = this.getWidth() - insets.left - insets.right;
        int availableHeight = this.getHeight() - insets.top - insets.bottom;
        NeonCortex.drawImage((Graphics)g2d, (Image)this.theImage, (int)xOffset, (int)yOffset);
        Color tmpColor = g2d.getColor();
        Area area = new Area(new Rectangle(xOffset, yOffset, availableWidth, availableHeight));
        area.subtract(new Area(this.theRectangle));
        g2d.setColor(new Color(200, 200, 200, 128));
        g2d.fill(area);
        g2d.setColor(Color.BLACK);
        g2d.draw(this.theRectangle);
        g2d.setColor(tmpColor);
        g2d.dispose();
    }

    void installOnScrollPane(JScrollPane aScrollPane) {
        if (this.theScrollPane != null) {
            this.uninstallFromScrollPane();
        }
        this.theScrollPane = aScrollPane;
        this.theFormerLayoutManager = this.theScrollPane.getLayout();
        this.theScrollPane.setLayout(new TweakedScrollPaneLayout());
        this.theScrollPane.firePropertyChange("layoutManager", false, true);
        this.theScrollPane.addPropertyChangeListener(COMPONENT_ORIENTATION, this.propertyChangeListener);
        this.theScrollPane.getViewport().addContainerListener(this.theViewPortViewListener);
        this.theScrollPane.setCorner("LOWER_TRAILING_CORNER", this.theButton);
        Component comp = this.theScrollPane.getViewport().getView();
        this.theComponent = comp instanceof JComponent ? (JComponent)comp : null;
        int dimension = UIManager.getInt("ScrollBar.width") - 4;
        this.theButton.setIcon(new TransitionAwareIcon(this.theButton, scheme -> SubstanceCortex.GlobalScope.getIconPack().getInspectIcon(dimension, scheme), "substance.widget.scroll.selector"));
        this.theScrollPane.doLayout();
    }

    void uninstallFromScrollPane() {
        if (this.theScrollPane == null) {
            return;
        }
        if (this.thePopupMenu.isVisible()) {
            this.thePopupMenu.setVisible(false);
        }
        this.theScrollPane.setCorner("LOWER_TRAILING_CORNER", null);
        this.theScrollPane.removePropertyChangeListener(COMPONENT_ORIENTATION, this.propertyChangeListener);
        this.theScrollPane.getViewport().removeContainerListener(this.theViewPortViewListener);
        this.theScrollPane.setLayout(this.theFormerLayoutManager);
        this.theScrollPane.firePropertyChange("layoutManager", true, false);
        this.theScrollPane = null;
    }

    private void display(Point aPointOnScreen) {
        if (this.theComponent == null) {
            return;
        }
        PreviewPainter previewPainter = WidgetUtilities.getComponentPreviewPainter(this.theScrollPane);
        if (!previewPainter.hasPreview(this.theComponent.getParent(), this.theComponent, 0)) {
            return;
        }
        Dimension pDimension = previewPainter.getPreviewWindowDimension(this.theComponent.getParent(), this.theComponent, 0);
        double compWidth = this.theComponent.getWidth();
        double compHeight = this.theComponent.getHeight();
        double scaleX = pDimension.getWidth() / compWidth;
        double scaleY = pDimension.getHeight() / compHeight;
        this.theScale = Math.min(scaleX, scaleY);
        int previewWidth = (int)((double)this.theComponent.getWidth() * this.theScale);
        int previewHeight = (int)((double)this.theComponent.getHeight() * this.theScale);
        this.theImage = SubstanceCoreUtilities.getBlankImage(previewWidth, previewHeight);
        Graphics2D g = this.theImage.createGraphics();
        previewPainter.previewComponent(null, this.theComponent, 0, g, 0, 0, this.theImage.getWidth(), this.theImage.getHeight());
        g.dispose();
        this.theStartRectangle = this.theComponent.getVisibleRect();
        Insets insets = this.getInsets();
        this.theStartRectangle.x = (int)(this.theScale * (double)this.theStartRectangle.x + (double)insets.left);
        this.theStartRectangle.y = (int)(this.theScale * (double)this.theStartRectangle.y + (double)insets.right);
        this.theStartRectangle.width = (int)((double)this.theStartRectangle.width * this.theScale);
        this.theStartRectangle.height = (int)((double)this.theStartRectangle.height * this.theScale);
        this.theRectangle = this.theStartRectangle;
        Dimension pref = this.thePopupMenu.getPreferredSize();
        Point buttonLocation = this.theButton.getLocationOnScreen();
        Point popupLocation = new Point((this.theButton.getWidth() - pref.width) / 2, (this.theButton.getHeight() - pref.height) / 2);
        Point centerPoint = new Point(buttonLocation.x + popupLocation.x + this.theRectangle.x + this.theRectangle.width / 2, buttonLocation.y + popupLocation.y + this.theRectangle.y + this.theRectangle.height / 2);
        try {
            new Robot().mouseMove(centerPoint.x, centerPoint.y);
            this.theStartPoint = centerPoint;
        }
        catch (Exception e) {
            this.theStartPoint = aPointOnScreen;
            popupLocation.x += this.theStartPoint.x - centerPoint.x;
            popupLocation.y += this.theStartPoint.y - centerPoint.y;
        }
        this.thePrevPoint = new Point(this.theStartPoint);
        this.toRestoreOriginal = true;
        this.thePopupMenu.show(this.theButton, popupLocation.x, popupLocation.y);
    }

    private void syncRectangle() {
        JViewport viewport = this.theScrollPane.getViewport();
        Rectangle viewRect = viewport.getViewRect();
        Insets insets = this.getInsets();
        Rectangle newRect = new Rectangle();
        newRect.x = (int)(this.theScale * (double)viewRect.x + (double)insets.left);
        newRect.y = (int)(this.theScale * (double)viewRect.y + (double)insets.top);
        newRect.width = (int)((double)viewRect.width * this.theScale);
        newRect.height = (int)((double)viewRect.height * this.theScale);
        Rectangle clip = new Rectangle();
        Rectangle.union(this.theRectangle, newRect, clip);
        clip.grow(2, 2);
        this.theRectangle = newRect;
        this.paintImmediately(clip);
    }

    private void scroll(final int aDeltaX, final int aDeltaY, boolean toAnimate) {
        if (this.theComponent == null) {
            return;
        }
        final Rectangle oldRectangle = this.theComponent.getVisibleRect();
        final Rectangle newRectangle = new Rectangle(oldRectangle.x + aDeltaX, oldRectangle.y + aDeltaY, oldRectangle.width, oldRectangle.height);
        if (toAnimate) {
            ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().timelineBuilder(this.theComponent).addCallback((TimelineCallback)new UIThreadTimelineCallbackAdapter(){

                public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                    if (oldState == Timeline.TimelineState.DONE && newState == Timeline.TimelineState.IDLE) {
                        ScrollPaneSelector.this.theComponent.scrollRectToVisible(newRectangle);
                        ScrollPaneSelector.this.syncRectangle();
                    }
                }

                public void onTimelinePulse(float durationFraction, float timelinePosition) {
                    int x = (int)((float)oldRectangle.x + timelinePosition * (float)aDeltaX);
                    int y = (int)((float)oldRectangle.y + timelinePosition * (float)aDeltaY);
                    ScrollPaneSelector.this.theComponent.scrollRectToVisible(new Rectangle(x, y, oldRectangle.width, oldRectangle.height));
                    ScrollPaneSelector.this.syncRectangle();
                }
            })).play();
        } else {
            this.theComponent.scrollRectToVisible(newRectangle);
            this.syncRectangle();
        }
    }
}

