/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.animation.effects;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.swing.SwingComponentTimeline;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class GhostingListener {
    protected ChangeListener modelListener;
    protected JComponent comp;
    protected ButtonModel buttonModel;
    static final String GHOST_LISTENER_KEY = "substance.internal.ghostListenerKey";
    protected Map<SubstanceSlices.AnimationFacet, Boolean> prevStateMap;
    private Timeline ghostIconRolloverTimeline;
    private Timeline ghostComponentPressedTimeline;
    private static Map<JComponent, Timeline> runningGhostRolloverTimelines = new HashMap<JComponent, Timeline>();
    private static Map<JComponent, Timeline> runningGhostPressTimelines = new HashMap<JComponent, Timeline>();

    public GhostingListener(final JComponent comp, ButtonModel buttonModel) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.prevStateMap = new HashMap<SubstanceSlices.AnimationFacet, Boolean>();
        this.prevStateMap.put(SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, buttonModel.isRollover());
        this.prevStateMap.put(SubstanceSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, buttonModel.isPressed());
        SwingComponentTimeline.Builder ghostIconRolloverTimelineBuilder = AnimationConfigurationManager.getInstance().timelineBuilder(comp);
        ghostIconRolloverTimelineBuilder.addCallback((TimelineCallback)new SwingRepaintCallback((Component)comp));
        SwingComponentTimeline.Builder ghostComponentPressedTimelineBuilder = AnimationConfigurationManager.getInstance().timelineBuilder(comp);
        ghostComponentPressedTimelineBuilder.addCallback((TimelineCallback)new SwingRepaintCallback((Component)comp));
        UIThreadTimelineCallbackAdapter ghostCallback = new UIThreadTimelineCallbackAdapter(){
            private boolean wasShowing = true;

            protected void repaintTopLevelWindows(float timelinePosition) {
                Window[] compWindow;
                if (comp == null) {
                    return;
                }
                boolean isShowing = comp.isShowing();
                if (!(!isShowing || (compWindow = SwingUtilities.getWindowAncestor(comp)).isDisplayable() && compWindow.isShowing() && compWindow.isVisible())) {
                    isShowing = false;
                }
                if (!isShowing) {
                    if (this.wasShowing) {
                        for (Window w : Window.getWindows()) {
                            if (!w.isDisplayable() || !w.isVisible() || !w.isShowing()) continue;
                            w.repaint();
                        }
                    }
                    this.wasShowing = false;
                    return;
                }
                Component root = SwingUtilities.getRoot(comp);
                Rectangle compRect = comp.getBounds();
                compRect.setLocation(comp.getLocationOnScreen());
                compRect.x -= compRect.width / 2;
                compRect.y -= compRect.height / 2;
                compRect.width *= 2;
                compRect.height *= 2;
                int rootRepaintX = compRect.x - root.getLocationOnScreen().x;
                int rootRepaintY = compRect.y - root.getLocationOnScreen().y;
                root.repaint(rootRepaintX, rootRepaintY, compRect.width, compRect.height);
                for (Window w : Window.getWindows()) {
                    if (w == root || !w.isDisplayable() || !w.isVisible() || !w.isShowing() || !w.getBounds().intersects(compRect)) continue;
                    int winRepaintX = compRect.x - w.getLocationOnScreen().x;
                    int winRepaintY = compRect.y - w.getLocationOnScreen().y;
                    w.repaint(winRepaintX, winRepaintY, compRect.width, compRect.height);
                }
            }

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState == Timeline.TimelineState.DONE && newState == Timeline.TimelineState.IDLE) {
                    this.repaintTopLevelWindows(1.0f);
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                this.repaintTopLevelWindows(timelinePosition);
            }
        };
        ghostIconRolloverTimelineBuilder.addCallback((TimelineCallback)ghostCallback);
        ghostComponentPressedTimelineBuilder.addCallback((TimelineCallback)ghostCallback);
        ghostIconRolloverTimelineBuilder.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState != Timeline.TimelineState.DONE || newState != Timeline.TimelineState.IDLE) return;
                Class<GhostingListener> clazz = GhostingListener.class;
                synchronized (GhostingListener.class) {
                    runningGhostRolloverTimelines.values().remove(GhostingListener.this.ghostIconRolloverTimeline);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            }
        });
        ghostComponentPressedTimelineBuilder.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState != Timeline.TimelineState.DONE || newState != Timeline.TimelineState.IDLE) return;
                Class<GhostingListener> clazz = GhostingListener.class;
                synchronized (GhostingListener.class) {
                    runningGhostPressTimelines.values().remove(GhostingListener.this.ghostComponentPressedTimeline);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            }
        });
        this.ghostIconRolloverTimeline = ghostIconRolloverTimelineBuilder.build();
        this.ghostComponentPressedTimeline = ghostComponentPressedTimelineBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void trackModelChange(SubstanceSlices.AnimationFacet animationFacet, boolean newState) {
        if (WidgetUtilities.toIgnoreAnimations(this.comp)) {
            return;
        }
        try {
            Class<GhostingListener> clazz;
            if (!this.prevStateMap.containsKey(animationFacet)) return;
            boolean prevState = this.prevStateMap.get(animationFacet);
            if (prevState) return;
            if (!newState) return;
            if (animationFacet == SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER) {
                clazz = GhostingListener.class;
                // MONITORENTER : org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener.class
                runningGhostRolloverTimelines.put(this.comp, this.ghostIconRolloverTimeline);
                // MONITOREXIT : clazz
                this.ghostIconRolloverTimeline.play();
            }
            if (animationFacet != SubstanceSlices.AnimationFacet.GHOSTING_BUTTON_PRESS) return;
            clazz = GhostingListener.class;
            // MONITORENTER : org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener.class
            runningGhostPressTimelines.put(this.comp, this.ghostComponentPressedTimeline);
            // MONITOREXIT : clazz
            this.ghostComponentPressedTimeline.play();
            return;
        }
        finally {
            this.prevStateMap.put(animationFacet, newState);
        }
    }

    public void registerListeners() {
        this.modelListener = e -> {
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, this.comp)) {
                this.trackModelChange(SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, this.buttonModel.isRollover());
            }
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, this.comp)) {
                this.trackModelChange(SubstanceSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, this.buttonModel.isPressed());
            }
        };
        this.buttonModel.addChangeListener(this.modelListener);
        this.comp.putClientProperty(GHOST_LISTENER_KEY, this);
    }

    public void unregisterListeners() {
        this.buttonModel.removeChangeListener(this.modelListener);
        this.comp.putClientProperty(GHOST_LISTENER_KEY, null);
    }

    public static synchronized Map<JComponent, Timeline> getRunningGhostRolloverTimelines() {
        return Collections.unmodifiableMap(runningGhostRolloverTimelines);
    }

    public static synchronized Map<JComponent, Timeline> getRunningGhostPressTimelines() {
        return Collections.unmodifiableMap(runningGhostPressTimelines);
    }

    public Timeline getGhostComponentPressedTimeline() {
        return this.ghostComponentPressedTimeline;
    }

    public Timeline getGhostIconRolloverTimeline() {
        return this.ghostIconRolloverTimeline;
    }
}

