/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EnumSet;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

@SubstanceInternalButton
@SubstanceInternalArrowButton
public final class SubstanceDropDownButton
extends JButton {
    public SubstanceDropDownButton(JComponent parent) {
        super("");
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.setEnabled(parent.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(parent.isEnabled());
        int fontSize = SubstanceSizeUtils.getComponentFontSize(parent);
        int tbInset = SubstanceSizeUtils.getAdjustedSize(fontSize, 1, 2, 1, false);
        this.setBorder(new EmptyBorder(tbInset + 1, 0, tbInset - 1, 0));
        SubstanceCoreUtilities.markButtonAsFlat(this);
        SubstanceCortex.ComponentScope.setButtonStraightSides(this, EnumSet.allOf(SubstanceSlices.Side.class));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        int clipDelta = (int)SubstanceSizeUtils.getBorderStrokeWidth();
        if (this.getComponentOrientation().isLeftToRight()) {
            g2d.clipRect(clipDelta, 0, width - clipDelta, height);
        } else {
            g2d.clipRect(0, 0, width - clipDelta, height);
        }
        super.paint(g2d);
        g2d.dispose();
    }

    static {
        AnimationConfigurationManager.getInstance().disallowAnimations(SubstanceSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, SubstanceDropDownButton.class);
        AnimationConfigurationManager.getInstance().disallowAnimations(SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, SubstanceDropDownButton.class);
    }
}

