/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.table.JTableHeader;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.swing.SwingComponentTimeline;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    private PropertyChangeListener substancePropertyChangeListener;
    private ChangeListener substanceVerticalScrollbarChangeListener;
    private Timeline horizontalScrollTimeline;
    private Set<SubstanceWidget> lafWidgets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceScrollPaneUI();
    }

    private SubstanceScrollPaneUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (SubstanceCoreUtilities.toDrawWatermark(scrollpane) && SubstanceCortex.ComponentScope.getCurrentSkin(scrollpane).getWatermark() != null) {
            scrollpane.setOpaque(false);
            scrollpane.getViewport().setOpaque(false);
        }
        SwingUtilities.invokeLater(() -> this.installTableHeaderCornerFiller(scrollpane));
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane c) {
        Component upperLeft;
        Component upperRight = c.getCorner("UPPER_RIGHT_CORNER");
        if (upperRight instanceof UIResource) {
            c.setCorner("UPPER_RIGHT_CORNER", null);
        }
        if ((upperLeft = c.getCorner("UPPER_LEFT_CORNER")) instanceof UIResource) {
            c.setCorner("UPPER_LEFT_CORNER", null);
        }
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults(c);
    }

    @Override
    protected void installListeners(final JScrollPane c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = evt -> {
            Color newBackgr;
            if ("substancelaf.internal.watermarkVisible".equals(evt.getPropertyName())) {
                boolean toBleed = SubstanceCoreUtilities.toDrawWatermark(c);
                c.setOpaque(!toBleed);
                c.getViewport().setOpaque(!toBleed);
                Component view = c.getViewport().getView();
                if (view instanceof JComponent) {
                    ((JComponent)view).setOpaque(!toBleed);
                }
            }
            if ("background".equals(evt.getPropertyName()) && !((newBackgr = (Color)evt.getNewValue()) instanceof UIResource)) {
                JScrollBar horizontal;
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (vertical != null && vertical.getBackground() instanceof UIResource) {
                    vertical.setBackground(newBackgr);
                }
                if ((horizontal = this.scrollpane.getHorizontalScrollBar()) != null && horizontal.getBackground() instanceof UIResource) {
                    horizontal.setBackground(newBackgr);
                }
            }
            if ("columnHeader".equals(evt.getPropertyName()) || "componentOrientation".equals(evt.getPropertyName()) || "ancestor".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.scrollpane != null) {
                        this.installTableHeaderCornerFiller(this.scrollpane);
                    }
                });
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceVerticalScrollbarChangeListener = e -> {
            if (c.getHorizontalScrollBar() != null && c.getHorizontalScrollBar().isVisible() && c.getViewport().getView() instanceof JTree) {
                JTree tree = (JTree)c.getViewport().getView();
                if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.TREE_SMART_SCROLL_ANIMATION, tree)) {
                    int finalDelta;
                    int currPivotX;
                    Rectangle viewportRect;
                    SubstanceTreeUI treeUI = (SubstanceTreeUI)tree.getUI();
                    int pivotX = treeUI.getPivotRendererX(viewportRect = c.getViewport().getViewRect());
                    int delta = pivotX - (currPivotX = viewportRect.x);
                    int finalX = viewportRect.x + delta;
                    if (finalX < 0) {
                        delta -= finalX;
                    }
                    if (Math.abs(finalDelta = delta) > viewportRect.width / 6) {
                        if (this.horizontalScrollTimeline != null) {
                            this.horizontalScrollTimeline.abort();
                        }
                        this.horizontalScrollTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)tree).addCallback((TimelineCallback)new UIThreadTimelineCallbackAdapter(){

                            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                                if ((double)timelinePosition >= 0.5) {
                                    int nudge = (int)((double)finalDelta * ((double)timelinePosition - 0.5));
                                    c.getViewport().setViewPosition(new Point(viewportRect.x + nudge, viewportRect.y));
                                }
                            }
                        })).setEase(durationFraction -> {
                            if ((double)durationFraction < 0.5) {
                                return 0.5f * durationFraction;
                            }
                            return 0.25f + (durationFraction - 0.5f) * 0.75f / 0.5f;
                        })).setDuration(2L * AnimationConfigurationManager.getInstance().getTimelineDuration())).build();
                        this.horizontalScrollTimeline.play();
                    }
                }
            }
        };
        c.getVerticalScrollBar().getModel().addChangeListener(this.substanceVerticalScrollbarChangeListener);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        JScrollPane jsp = (JScrollPane)c;
        jsp.getVerticalScrollBar().getModel().removeChangeListener(this.substanceVerticalScrollbarChangeListener);
        this.substanceVerticalScrollbarChangeListener = null;
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        JScrollPane jsp = (JScrollPane)c;
        LayoutManager lm = jsp.getLayout();
        ScrollPaneLayout scrollLm = null;
        if (lm instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)lm;
        }
        if (scrollLm != null) {
            HashSet<Component> corners = new HashSet<Component>();
            if (scrollLm.getCorner("LOWER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("LOWER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (SubstanceCoreUtilities.isOpaque(c)) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(SubstanceColorUtilities.getBackgroundFillColorScrollBar(this.scrollpane.getVerticalScrollBar()));
                for (Component corner : corners) {
                    g2d.fill(corner.getBounds());
                }
                JScrollBar horizontal = this.scrollpane.getHorizontalScrollBar();
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (horizontal != null && vertical != null) {
                    if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
                        if (scrollLm.getCorner("LOWER_RIGHT_CORNER") == null) {
                            g2d.fillRect(horizontal.getX() + horizontal.getWidth(), horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                        }
                    } else if (scrollLm.getCorner("LOWER_LEFT_CORNER") == null) {
                        g2d.fillRect(0, horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                    }
                }
            }
        }
        super.paint(g, c);
    }

    private void installTableHeaderCornerFiller(JScrollPane scrollpane) {
        boolean canReplace;
        JViewport columnHeader = scrollpane.getColumnHeader();
        if (columnHeader == null) {
            return;
        }
        Component columnHeaderComp = columnHeader.getView();
        if (!(columnHeaderComp instanceof JTableHeader)) {
            return;
        }
        JTableHeader tableHeader = (JTableHeader)columnHeaderComp;
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (!(tableHeaderUI instanceof SubstanceTableHeaderUI)) {
            return;
        }
        SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
        JComponent scrollPaneCornerFiller = ui.getScrollPaneCornerFiller();
        String cornerKey = scrollpane.getComponentOrientation().isLeftToRight() ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        Component cornerComp = scrollpane.getCorner(cornerKey);
        boolean bl = canReplace = cornerComp == null || cornerComp instanceof UIResource;
        if (canReplace) {
            scrollpane.setCorner(cornerKey, scrollPaneCornerFiller);
        }
    }
}

