/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceWidget;

public class SubstanceWidgetRepository {
    private Map<Class<?>, Set<WidgetClassInfo>> widgets = new HashMap();
    private Set<String> widgetClassesToIgnore = new HashSet<String>();
    private static SubstanceWidgetRepository repository;

    private SubstanceWidgetRepository() {
    }

    public static synchronized SubstanceWidgetRepository getRepository() {
        if (repository == null) {
            repository = new SubstanceWidgetRepository();
            repository.registerWidget("org.pushingpixels.substance.internal.widget.animation.effects.GhostAnimationWidget", JButton.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.animation.effects.GhostAnimationWidget", JToggleButton.class, true);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.desktop.DesktopIconHoverPreviewWidget", JInternalFrame.JDesktopIcon.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.menu.MenuSearchWidget", JMenuBar.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.scroll.AutoScrollWidget", JScrollPane.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.scroll.ScrollPaneSelectorWidget", JScrollPane.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.text.PasswordStrengthCheckerWidget", JPasswordField.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.text.LockBorderWidget", JTextComponent.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.text.SelectAllOnFocusGainWidget", JTextComponent.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.text.SelectOnEscapeWidget", JTextComponent.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.text.EditContextMenuWidget", JTextComponent.class, false);
            repository.registerWidget("org.pushingpixels.substance.internal.widget.tree.dnd.TreeDragAndDropWidget", JTree.class, false);
        }
        return repository;
    }

    public synchronized void registerWidget(String widgetClassName, List<Class<?>> supportedClasses) {
        for (Class<?> clazz : supportedClasses) {
            this.registerWidget(widgetClassName, clazz, false);
        }
    }

    public synchronized void registerWidget(String widgetClassName, Class<?> supportedClass, boolean isExact) {
        if (JComponent.class.isAssignableFrom(supportedClass) && !this.widgets.containsKey(supportedClass)) {
            this.widgets.put(supportedClass, new HashSet());
        }
        for (WidgetClassInfo registered : this.widgets.get(supportedClass)) {
            if (!registered.className.equals(widgetClassName)) continue;
            return;
        }
        this.widgets.get(supportedClass).add(new WidgetClassInfo(widgetClassName, isExact));
    }

    public synchronized Set<SubstanceWidget> getMatchingWidgets(JComponent jcomp) {
        HashSet<SubstanceWidget> result = new HashSet<SubstanceWidget>();
        boolean isOriginator = true;
        for (Class<?> clazz = jcomp.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<WidgetClassInfo> registered = this.widgets.get(clazz);
            if (registered != null) {
                for (WidgetClassInfo widgetClassInfo : registered) {
                    if (widgetClassInfo.isExact && !isOriginator) continue;
                    try {
                        Object widgetObj;
                        String widgetClassName = widgetClassInfo.className;
                        if (this.widgetClassesToIgnore.contains(widgetClassName) || !((widgetObj = Class.forName(widgetClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof SubstanceWidget)) continue;
                        SubstanceWidget widget = (SubstanceWidget)widgetObj;
                        widget.setComponent(jcomp);
                        result.add(widget);
                    }
                    catch (Throwable throwable) {}
                }
            }
            isOriginator = false;
        }
        return result;
    }

    public synchronized void addToIgnoreWidgets(String widgetClassName) {
        this.widgetClassesToIgnore.add(widgetClassName);
    }

    private static class WidgetClassInfo {
        public String className;
        public boolean isExact;

        public WidgetClassInfo(String className, boolean isExact) {
            this.className = className;
            this.isExact = isExact;
        }
    }
}

