/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class NightShadeSkin
extends SubstanceSkin {
    public static final String NAME = "Night Shade";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public NightShadeSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/nightshade.colorschemes");
        SubstanceColorScheme activeScheme = schemes.get("Night Shade Active");
        SubstanceColorScheme enabledScheme = schemes.get("Night Shade Enabled");
        SubstanceColorScheme disabledScheme = schemes.get("Night Shade Disabled");
        SubstanceColorScheme disabledSelectedScheme = schemes.get("Night Shade Disabled Selected");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(disabledSelectedScheme, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderScheme = schemes.get("Night Shade Border");
        defaultSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme markActiveScheme = schemes.get("Night Shade Mark Active");
        defaultSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme separatorScheme = schemes.get("Night Shade Separator");
        defaultSchemeBundle.registerColorScheme(separatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(schemes.get("Night Shade Tab Border"), SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.getActiveStates());
        SubstanceColorScheme watermarkScheme = schemes.get("Night Shade Watermark");
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, watermarkScheme, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorSchemeBundle decorationsSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        decorationsSchemeBundle.registerAlpha(0.4f, ComponentState.DISABLED_UNSELECTED);
        decorationsSchemeBundle.registerColorScheme(enabledScheme, ComponentState.DISABLED_UNSELECTED);
        decorationsSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        decorationsSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        decorationsSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        SubstanceColorScheme separatorDecorationsScheme = schemes.get("Night Shade Decorations Separator");
        decorationsSchemeBundle.registerColorScheme(separatorDecorationsScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme decorationsWatermarkScheme = schemes.get("Night Shade Decorations Watermark");
        this.registerDecorationAreaSchemeBundle(decorationsSchemeBundle, decorationsWatermarkScheme, SubstanceSlices.DecorationAreaType.TOOLBAR, SubstanceSlices.DecorationAreaType.FOOTER);
        SubstanceColorScheme generalWatermarkScheme = schemes.get("Night Shade General Watermark");
        this.registerDecorationAreaSchemeBundle(decorationsSchemeBundle, generalWatermarkScheme, SubstanceSlices.DecorationAreaType.GENERAL);
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        decorationsSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(enabledScheme, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme headerBorderScheme = schemes.get("Night Shade Header Border");
        headerSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(headerBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        headerSchemeBundle.registerHighlightAlpha(0.7f, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ROLLOVER_ARMED, ComponentState.ARMED);
        headerSchemeBundle.registerHighlightAlpha(0.8f, ComponentState.SELECTED);
        headerSchemeBundle.registerHighlightAlpha(1.0f, ComponentState.ROLLOVER_SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ROLLOVER_ARMED, ComponentState.ARMED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme headerWatermarkScheme = schemes.get("Night Shade Header Watermark");
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerWatermarkScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        this.setTabFadeStart(0.2);
        this.setTabFadeEnd(0.9);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), SubstanceSlices.DecorationAreaType.FOOTER);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(scheme -> SubstanceColorUtilities.deriveByBrightness(scheme.getUltraDarkColor(), -0.5f));
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(scheme -> SubstanceColorUtilities.deriveByBrightness(scheme.getUltraDarkColor(), -0.5f), scheme -> SubstanceColorUtilities.getAlphaColor(scheme.getForegroundColor(), 32));
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, SubstanceSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.LIGHT});
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new ClassicBorderPainter(), new DelegateBorderPainter("Night Shade Inner", new ClassicBorderPainter(), 0x40FFFFFF, 0x20FFFFFF, 0xFFFFFF, scheme -> scheme.tint(0.2f)));
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

