/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.StandardFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class DustSkin
extends SubstanceSkin {
    public static final String NAME = "Dust";
    private BottomLineOverlayPainter menuOverlayPainter;
    private TopLineOverlayPainter toolbarOverlayPainter;

    public DustSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/dust.colorschemes");
        SubstanceColorScheme activeScheme = schemes.get("Dust Active");
        SubstanceColorScheme enabledScheme = schemes.get("Dust Enabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, enabledScheme);
        defaultSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(enabledScheme, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderEnabledScheme = schemes.get("Dust Border Enabled");
        SubstanceColorScheme borderActiveScheme = schemes.get("Dust Border Active");
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme.shade(0.3), SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme headerActiveScheme = schemes.get("Dust Header Active");
        SubstanceColorScheme headerEnabledScheme = schemes.get("Dust Header Enabled");
        SubstanceColorScheme headerDisabledScheme = schemes.get("Dust Header Disabled");
        SubstanceColorScheme headerWatermarkScheme = schemes.get("Dust Header Watermark");
        SubstanceColorScheme headerSeparatorScheme = schemes.get("Dust Header Separator");
        SubstanceColorScheme headerBorderScheme = schemes.get("Dust Header Border");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(headerActiveScheme, headerEnabledScheme, headerDisabledScheme);
        headerSchemeBundle.registerAlpha(0.7f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(headerDisabledScheme, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(headerBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(headerSeparatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        headerSchemeBundle.registerHighlightAlpha(1.0f, new ComponentState[0]);
        headerSchemeBundle.registerHighlightColorScheme(headerActiveScheme, new ComponentState[0]);
        headerSchemeBundle.registerHighlightAlpha(0.0f, ComponentState.ENABLED);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerWatermarkScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER, SubstanceSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.1);
        this.setTabFadeEnd(0.3);
        this.menuOverlayPainter = new BottomLineOverlayPainter(scheme -> SubstanceColorUtilities.deriveByBrightness(scheme.getUltraDarkColor(), -0.5f));
        this.toolbarOverlayPainter = new TopLineOverlayPainter(scheme -> SubstanceColorUtilities.getAlphaColor(scheme.getForegroundColor(), 32));
        this.addOverlayPainter(this.menuOverlayPainter, SubstanceSlices.DecorationAreaType.HEADER);
        this.addOverlayPainter(this.toolbarOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.fillPainter = new StandardFillPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new ClassicBorderPainter(), new DelegateBorderPainter("Dust Inner", new ClassicBorderPainter(), 0x60FFFFFF, 0x30FFFFFF, 0x18FFFFFF, scheme -> scheme.shiftBackground(scheme.getUltraLightColor(), 0.8).tint(0.6).saturate(0.2)));
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

