/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public final class BottomShadowOverlayPainter
implements SubstanceOverlayPainter {
    private static BottomShadowOverlayPainter INSTANCE;

    public static synchronized BottomShadowOverlayPainter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BottomShadowOverlayPainter();
        }
        return INSTANCE;
    }

    private BottomShadowOverlayPainter() {
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        Color shadowColor = SubstanceColorUtilities.deriveByBrightness(SubstanceColorUtilities.getBackgroundFillColor(comp), -0.4f);
        Component topMostWithSameDecorationAreaType = SubstanceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        int topHeight = topMostWithSameDecorationAreaType.getHeight();
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        Graphics2D fillGraphics = (Graphics2D)graphics.create();
        fillGraphics.translate(0, -dy);
        int shadowHeight = 4;
        GradientPaint fillPaint = new GradientPaint(0.0f, topHeight - shadowHeight, SubstanceColorUtilities.getAlphaColor(shadowColor, 0), 0.0f, topHeight, SubstanceColorUtilities.getAlphaColor(shadowColor, 128));
        fillGraphics.setPaint(fillPaint);
        fillGraphics.fillRect(0, topHeight - shadowHeight, width, shadowHeight);
        fillGraphics.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Bottom Shadow";
    }
}

