/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

class DerivedColorsResolverDark
implements SchemeDerivedColors {
    SubstanceColorScheme scheme;

    public DerivedColorsResolverDark(SubstanceColorScheme scheme) {
        if (!scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be dark: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    @Override
    public Color getWatermarkStampColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getUltraLightColor(), 30);
    }

    @Override
    public Color getWatermarkDarkColor() {
        return this.scheme.getLightColor();
    }

    @Override
    public Color getWatermarkLightColor() {
        return this.scheme.getUltraLightColor();
    }

    @Override
    public Color getLineColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return SubstanceColorUtilities.deriveByBrightness(this.scheme.getUltraDarkColor(), -0.5f);
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return SubstanceColorUtilities.deriveByBrightness(this.scheme.getUltraLightColor(), 0.2f);
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getFocusRingColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getForegroundColor(), 192);
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getLightColor(), 0.4f);
    }
}

