/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import javax.swing.BoundedRangeModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;
import org.pushingpixels.trident.swing.SwingComponentTimeline;

public class SubstanceProgressBarUI
extends BasicProgressBarUI {
    private static final ComponentState DETERMINATE_SELECTED = new ComponentState("determinate enabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.DETERMINATE, SubstanceSlices.ComponentStateFacet.SELECTION}, null);
    private static final ComponentState DETERMINATE_SELECTED_DISABLED = new ComponentState("determinate disabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DETERMINATE, SubstanceSlices.ComponentStateFacet.SELECTION}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE});
    private static final ComponentState INDETERMINATE_SELECTED = new ComponentState("indeterminate enabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.SELECTION}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DETERMINATE});
    private static final ComponentState INDETERMINATE_SELECTED_DISABLED = new ComponentState("indeterminate disabled", null, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DETERMINATE, SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.SELECTION});
    private static final SubstanceFillPainter progressFillPainter = new FractionBasedFillPainter("Progress fill (internal)", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
    private static LazyResettableHashMap<BufferedImage> stripeMap = new LazyResettableHashMap("SubstanceProgressBarUI.stripeMap");
    private static LazyResettableHashMap<BufferedImage> backgroundMap = new LazyResettableHashMap("SubstanceProgressBarUI.backgroundMap");
    private static LazyResettableHashMap<BufferedImage> progressMap = new LazyResettableHashMap("SubstanceProgressBarUI.progressMap");
    private float animationPosition;
    private ChangeListener substanceValueChangeListener;
    private PropertyChangeListener substancePropertyChangeListener;
    private int margin;
    private int displayedValue;
    private Timeline displayTimeline;
    private Timeline indeterminateLoopTimeline;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceProgressBarUI();
    }

    private SubstanceProgressBarUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.displayedValue = this.progressBar.getValue();
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.margin = 0;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceValueChangeListener = new SubstanceChangeListener();
        this.progressBar.addChangeListener(this.substanceValueChangeListener);
        this.substancePropertyChangeListener = evt -> {
            if ("font".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.progressBar != null) {
                        this.progressBar.updateUI();
                    }
                });
            }
        };
        this.progressBar.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.substanceValueChangeListener);
        this.substanceValueChangeListener = null;
        this.progressBar.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    private static BufferedImage getStripe(int baseSize, boolean isRotated, SubstanceColorScheme colorScheme) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(baseSize, isRotated, colorScheme.getDisplayName());
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getStripe(baseSize, colorScheme.getUltraLightColor());
            if (isRotated) {
                result = SubstanceImageCreator.getRotated(result, 1, false);
            }
            stripeMap.put(key, result);
        }
        return result;
    }

    private static BufferedImage getDeterminateBackground(JProgressBar bar, int width, int height, SubstanceColorScheme scheme, SubstanceFillPainter fillPainter, int orientation, ComponentOrientation componentOrientation) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName(), fillPainter.getDisplayName(), orientation, componentOrientation);
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D g2d = result.createGraphics();
            float radius = 0.5f * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(bar));
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, null);
            fillPainter.paintContourBackground(g2d, bar, width, height, contour, false, scheme, true);
            g2d.dispose();
            if (orientation == 1) {
                result = SubstanceImageCreator.getRotated(result, 3, false);
            }
            backgroundMap.put(key, result);
        }
        return result;
    }

    private static BufferedImage getDeterminateProgress(JProgressBar bar, int width, int height, boolean isFull, SubstanceColorScheme scheme, SubstanceFillPainter fillPainter, int orientation, ComponentOrientation componentOrientation) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName(), fillPainter.getDisplayName(), orientation, componentOrientation);
        BufferedImage result = progressMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D g2d = result.createGraphics();
            float radius = 0.5f * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(bar));
            SubstanceSlices.Side straightSide = orientation == 1 ? SubstanceSlices.Side.RIGHT : (componentOrientation.isLeftToRight() ? SubstanceSlices.Side.RIGHT : SubstanceSlices.Side.LEFT);
            EnumSet<SubstanceSlices.Side> straightSides = isFull ? null : EnumSet.of(straightSide);
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides);
            fillPainter.paintContourBackground(g2d, bar, width, height, contour, false, scheme, true);
            g2d.dispose();
            if (orientation == 1) {
                result = SubstanceImageCreator.getRotated(result, 3, false);
            }
            progressMap.put(key, result);
        }
        return result;
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        BufferedImage back;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        ComponentState fillState = this.getFillState();
        ComponentState progressState = this.getProgressState();
        int barRectWidth = this.progressBar.getWidth() - 2 * this.margin;
        int barRectHeight = this.progressBar.getHeight() - 2 * this.margin;
        int amountFull = this.getAmountFull(new Insets(this.margin, this.margin, this.margin, this.margin), barRectWidth, barRectHeight);
        Graphics2D g2d = (Graphics2D)g.create();
        float stateAlpha = SubstanceColorSchemeUtilities.getAlpha(this.progressBar, fillState);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, stateAlpha, g));
        SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, fillState);
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            back = SubstanceProgressBarUI.getDeterminateBackground(this.progressBar, barRectWidth, barRectHeight, fillScheme, fillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
            NeonCortex.drawImage((Graphics)g2d, (Image)back, (int)this.margin, (int)this.margin);
        } else {
            back = SubstanceProgressBarUI.getDeterminateBackground(this.progressBar, barRectHeight, barRectWidth, fillScheme, fillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
            NeonCortex.drawImage((Graphics)g2d, (Image)back, (int)this.margin, (int)this.margin);
        }
        if (amountFull > 0) {
            boolean isFull = this.progressBar.getModel().getValue() == this.progressBar.getMaximum();
            SubstanceColorScheme progressColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, progressState);
            if (this.progressBar.getOrientation() == 0) {
                int progressWidth = amountFull;
                int progressHeight = barRectHeight;
                if (progressWidth > 0 && progressHeight > 0) {
                    BufferedImage progress = SubstanceProgressBarUI.getDeterminateProgress(this.progressBar, progressWidth, progressHeight, isFull, progressColorScheme, progressFillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
                    if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                        NeonCortex.drawImage((Graphics)g2d, (Image)progress, (int)this.margin, (int)this.margin);
                    } else {
                        NeonCortex.drawImage((Graphics)g2d, (Image)progress, (int)(this.margin + barRectWidth - amountFull), (int)this.margin);
                    }
                }
            } else {
                int progressWidth = barRectWidth;
                int progressHeight = amountFull;
                if (amountFull > 0 && progressHeight > 0) {
                    BufferedImage progress = SubstanceProgressBarUI.getDeterminateProgress(this.progressBar, progressHeight, progressWidth, isFull, progressColorScheme, progressFillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
                    NeonCortex.drawImage((Graphics)g2d, (Image)progress, (int)this.margin, (int)(this.margin + barRectHeight - progressHeight));
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, 1.0f, g));
            this.paintString(g2d, this.margin, this.margin, barRectWidth, barRectHeight, amountFull, new Insets(this.margin, this.margin, this.margin, this.margin));
        }
        g2d.dispose();
    }

    @Override
    protected Color getSelectionBackground() {
        ComponentState fillState = this.getFillState();
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, fillState);
        return SubstanceColorUtilities.getForegroundColor(scheme);
    }

    @Override
    protected Color getSelectionForeground() {
        ComponentState progressState = this.getProgressState();
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, progressState);
        return SubstanceColorUtilities.getForegroundColor(scheme);
    }

    @Override
    public void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        ComponentState progressState = this.getProgressState();
        int barRectWidth = this.progressBar.getWidth() - 2 * this.margin;
        int barRectHeight = this.progressBar.getHeight() - 2 * this.margin;
        int valComplete = this.progressBar.getOrientation() == 0 ? (int)(this.animationPosition * (float)(2 * barRectHeight + 1)) : (int)(this.animationPosition * (float)(2 * barRectWidth + 1));
        Graphics2D g2d = (Graphics2D)g.create();
        float stateAlpha = SubstanceColorSchemeUtilities.getAlpha(this.progressBar, progressState);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, stateAlpha, g));
        float radius = 0.5f * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.progressBar));
        g2d.clip(new RoundRectangle2D.Float(this.margin, this.margin, barRectWidth, barRectHeight, radius, radius));
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, progressState);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(this.progressBar, g2d, this.margin, this.margin, barRectWidth, barRectHeight, scheme, SubstanceProgressBarUI.getStripe(barRectHeight, false, scheme), valComplete, 0.6f, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(this.progressBar, g2d, this.margin, this.margin, barRectWidth, barRectHeight, scheme, SubstanceProgressBarUI.getStripe(barRectWidth, true, scheme), 2 * barRectWidth - valComplete, 0.6f, true);
        }
        if (this.progressBar.isStringPainted()) {
            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, 1.0f, g));
            this.paintString(g2d, this.margin, this.margin, barRectWidth, barRectHeight, barRectWidth, new Insets(this.margin, this.margin, this.margin, this.margin));
        }
        g2d.dispose();
    }

    private ComponentState getFillState() {
        return this.progressBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
    }

    private ComponentState getProgressState() {
        if (this.progressBar.isIndeterminate()) {
            return this.progressBar.isEnabled() ? INDETERMINATE_SELECTED : INDETERMINATE_SELECTED_DISABLED;
        }
        return this.progressBar.isEnabled() ? DETERMINATE_SELECTED : DETERMINATE_SELECTED_DISABLED;
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        int barRectWidth = this.progressBar.getWidth() - 2 * this.margin;
        int barRectHeight = this.progressBar.getHeight() - 2 * this.margin;
        return new Rectangle(this.margin, this.margin, barRectWidth, barRectHeight);
    }

    @Override
    protected void startAnimationTimer() {
        int cycleDuration = UIManager.getInt("ProgressBar.cycleTime");
        if (cycleDuration == 0) {
            cycleDuration = 1000;
        }
        this.indeterminateLoopTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)this.progressBar).setDuration((long)cycleDuration)).addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (SubstanceProgressBarUI.this.progressBar != null && SubstanceProgressBarUI.this.progressBar.isVisible()) {
                    SubstanceProgressBarUI.this.progressBar.repaint();
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                if (SubstanceProgressBarUI.this.progressBar != null && SubstanceProgressBarUI.this.progressBar.isVisible()) {
                    SubstanceProgressBarUI.this.progressBar.repaint();
                }
            }
        })).addPropertyToInterpolate(Timeline.property((String)"animationPosition").from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(1.0f)).setWith((obj, fieldName, value) -> {
            this.animationPosition = value.floatValue();
        }))).build();
        this.indeterminateLoopTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
    }

    @Override
    protected void stopAnimationTimer() {
        this.indeterminateLoopTimeline.abort();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceProgressBarUI: \n");
        sb.append("\t" + stripeMap.size() + " stripes");
        return sb.toString();
    }

    @Override
    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        long span = model.getMaximum() - model.getMinimum();
        double percentComplete = (double)(this.displayedValue - model.getMinimum()) / (double)span;
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * percentComplete) : (int)Math.round((double)height * percentComplete);
        }
        return amountFull;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        int size = SubstanceSizeUtils.getComponentFontSize(this.progressBar);
        size += 2 * SubstanceSizeUtils.getAdjustedSize(size, 1, 4, 1, false);
        return new Dimension(146 + SubstanceSizeUtils.getAdjustedSize(size, 0, 1, 10, false), size);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        int size = SubstanceSizeUtils.getComponentFontSize(this.progressBar);
        size += 2 * SubstanceSizeUtils.getAdjustedSize(size, 1, 4, 1, false);
        return new Dimension(size, 146 + SubstanceSizeUtils.getAdjustedSize(size, 0, 1, 10, false));
    }

    @Override
    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.progressBar.getOrientation() == 0) {
            if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                if (this.progressBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(g, x, y, width, height, this.boxRect.x, this.boxRect.width, b);
                } else {
                    this.paintString(g, x, y, width, height, x, amountFull, b);
                }
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull, b);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(g, x, y, width, height, this.boxRect.y, this.boxRect.height, b);
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull, b);
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        String progressString = this.progressBar.getString();
        Rectangle renderRectangle = this.getStringRectangle(progressString, x, y, width, height);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceTextUtilities.paintText(g, this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(amountFull, y, this.progressBar.getWidth() - amountFull, height));
            SubstanceTextUtilities.paintText(g, this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(fillStart, y, amountFull, height));
        } else {
            SubstanceTextUtilities.paintVerticalText(g, this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(x, y, width, this.progressBar.getHeight() - amountFull), this.progressBar.getComponentOrientation().isLeftToRight());
            SubstanceTextUtilities.paintVerticalText(g, this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(x, fillStart, width, amountFull), this.progressBar.getComponentOrientation().isLeftToRight());
        }
    }

    private Rectangle getStringRectangle(String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = SubstanceMetricsUtilities.getFontMetrics(this.progressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        if (this.progressBar.getOrientation() == 0) {
            return new Rectangle(x + Math.round(width / 2 - stringWidth / 2), y + (height - fontSizer.getHeight()) / 2, stringWidth, fontSizer.getHeight());
        }
        return new Rectangle(x + (width - fontSizer.getHeight()) / 2, y + Math.round(height / 2 - stringWidth / 2), fontSizer.getHeight(), stringWidth);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    private final class SubstanceChangeListener
    implements ChangeListener {
        private SubstanceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            boolean hasParent;
            int pixelDelta;
            SubstanceCoreUtilities.testComponentStateChangeThreadingViolation(SubstanceProgressBarUI.this.progressBar);
            int currValue = SubstanceProgressBarUI.this.progressBar.getValue();
            int span = SubstanceProgressBarUI.this.progressBar.getMaximum() - SubstanceProgressBarUI.this.progressBar.getMinimum();
            int barRectWidth = SubstanceProgressBarUI.this.progressBar.getWidth() - 2 * SubstanceProgressBarUI.this.margin;
            int barRectHeight = SubstanceProgressBarUI.this.progressBar.getHeight() - 2 * SubstanceProgressBarUI.this.margin;
            int totalPixels = SubstanceProgressBarUI.this.progressBar.getOrientation() == 0 ? barRectWidth : barRectHeight;
            int n = pixelDelta = span <= 0 ? 0 : (currValue - SubstanceProgressBarUI.this.displayedValue) * totalPixels / span;
            if (SubstanceProgressBarUI.this.displayTimeline != null) {
                SubstanceProgressBarUI.this.displayTimeline.abort();
            }
            SubstanceProgressBarUI.this.displayTimeline = (Timeline)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().timelineBuilder(SubstanceProgressBarUI.this.progressBar).addPropertyToInterpolate(Timeline.property((String)"displayedValue").from((Object)SubstanceProgressBarUI.this.displayedValue).to((Object)currValue).setWith((obj, fieldName, value) -> {
                SubstanceProgressBarUI.this.displayedValue = value;
                if (SubstanceProgressBarUI.this.progressBar != null) {
                    SubstanceProgressBarUI.this.progressBar.repaint();
                }
            }))).setEase((TimelineEase)new Spline(0.4f))).build();
            boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, SubstanceProgressBarUI.this.progressBar) != null;
            boolean bl = hasParent = SubstanceProgressBarUI.this.progressBar.getParent() != null;
            if (hasParent && !isInCellRenderer && Math.abs(pixelDelta) > 5) {
                SubstanceProgressBarUI.this.displayTimeline.play();
            } else {
                SubstanceProgressBarUI.this.displayedValue = currValue;
                SubstanceProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

