/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.highlight.SubstanceHighlightPainter;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class HighlightPainterUtils {
    private static final LazyResettableHashMap<BufferedImage> smallCache = new LazyResettableHashMap("SubstanceHighlightUtils");

    public static void paintHighlight(Graphics g, CellRendererPane rendererPane, Component c, Rectangle rect, float borderAlpha, Set<SubstanceSlices.Side> openSides, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Component compForQuerying = rendererPane != null ? rendererPane : c;
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(compForQuerying);
        SubstanceHighlightPainter highlightPainter = skin.getHighlightPainter();
        SubstanceBorderPainter highlightBorderPainter = SubstanceCoreUtilities.getHighlightBorderPainter(compForQuerying);
        Graphics2D g2d = (Graphics2D)g.create(rect.x, rect.y, rect.width, rect.height);
        if (openSides == null) {
            openSides = EnumSet.noneOf(SubstanceSlices.Side.class);
        }
        if (rect.width * rect.height < 100000) {
            Object openKey = "";
            for (SubstanceSlices.Side oSide : openSides) {
                openKey = (String)openKey + oSide.name() + "-";
            }
            HashMapKey key = SubstanceCoreUtilities.getHashKey(highlightPainter.getDisplayName(), highlightBorderPainter.getDisplayName(), rect.width, rect.height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), Float.valueOf(borderAlpha), openKey);
            BufferedImage result = smallCache.get(key);
            if (result == null) {
                result = HighlightPainterUtils.createHighlighterImage(c, rect, borderAlpha, openSides, fillScheme, borderScheme, highlightPainter, highlightBorderPainter);
                smallCache.put(key, result);
            }
            NeonCortex.drawImage((Graphics)g2d, (Image)result, (int)0, (int)0);
        }
    }

    private static BufferedImage createHighlighterImage(Component c, Rectangle rect, float borderAlpha, Set<SubstanceSlices.Side> openSides, SubstanceColorScheme currScheme, SubstanceColorScheme currBorderScheme, SubstanceHighlightPainter highlightPainter, SubstanceBorderPainter highlightBorderPainter) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(rect.width, rect.height);
        Graphics2D resGraphics = result.createGraphics();
        highlightPainter.paintHighlight(resGraphics, c, rect.width, rect.height, currScheme);
        HighlightPainterUtils.paintHighlightBorder(resGraphics, c, rect.width, rect.height, borderAlpha, openSides, highlightBorderPainter, currBorderScheme);
        resGraphics.dispose();
        return result;
    }

    private static void paintHighlightBorder(Graphics2D graphics, Component comp, int width, int height, float borderAlpha, Set<SubstanceSlices.Side> openSides, SubstanceBorderPainter highlightBorderPainter, SubstanceColorScheme borderColorScheme) {
        if (borderAlpha <= 0.0f) {
            return;
        }
        int openDelta = 3 + (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth());
        int deltaLeft = openSides.contains((Object)SubstanceSlices.Side.LEFT) ? openDelta : 0;
        int deltaRight = openSides.contains((Object)SubstanceSlices.Side.RIGHT) ? openDelta : 0;
        int deltaTop = openSides.contains((Object)SubstanceSlices.Side.TOP) ? openDelta : 0;
        int deltaBottom = openSides.contains((Object)SubstanceSlices.Side.BOTTOM) ? openDelta : 0;
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth();
        Rectangle2D.Float contour = new Rectangle2D.Float(borderDelta / 2.0f, borderDelta / 2.0f, (float)(width + deltaLeft + deltaRight) - borderDelta, (float)(height + deltaTop + deltaBottom) - borderDelta);
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-deltaLeft, -deltaTop);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
        Rectangle2D.Float contourInner = new Rectangle2D.Float(1.5f * borderDelta, 1.5f * borderDelta, (float)(width + deltaLeft + deltaRight) - 3.0f * borderDelta, (float)(height + deltaTop + deltaBottom) - 3.0f * borderDelta);
        highlightBorderPainter.paintBorder(g2d, comp, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderColorScheme);
        g2d.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceHighlightUtils: \n");
        sb.append("\t" + smallCache.size() + " smalls");
        return sb.toString();
    }
}

