/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.neon.icon.NeonIconUIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.ThemedIconAwareRenderer;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    private PropertyChangeListener substancePropertyChangeListener;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceLabelUI();
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = evt -> {
            if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("substancelaf.lockopacity"))) {
                c.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        NeonIconUIResource themedIcon = null;
        float rolloverAmount = 0.0f;
        if (label.isEnabled()) {
            icon = label.getIcon();
            if (icon != null && SubstanceCoreUtilities.useThemedDefaultIcon(label)) {
                if (label instanceof ThemedIconAwareRenderer) {
                    ThemedIconAwareRenderer themedIconAwareRenderer = (ThemedIconAwareRenderer)((Object)label);
                    rolloverAmount = themedIconAwareRenderer.getRolloverArmAmount();
                    themedIcon = SubstanceCoreUtilities.getThemedIcon(c, icon);
                } else {
                    icon = SubstanceCoreUtilities.getThemedIcon(c, icon);
                }
            }
        } else {
            icon = label.getDisabledIcon();
        }
        if (icon == null && text == null) {
            return;
        }
        Insets insets = label.getInsets(this.paintViewInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, label.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        BackgroundPaintingUtils.updateIfOpaque(g2d, c);
        if (icon != null) {
            g2d.translate(this.paintIconR.x, this.paintIconR.y);
            if (themedIcon != null) {
                if (rolloverAmount > 0.0f) {
                    themedIcon.paintIcon(c, g2d, 0, 0);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(c, rolloverAmount, g));
                    icon.paintIcon(c, g2d, 0, 0);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
                } else {
                    themedIcon.paintIcon(c, g2d, 0, 0);
                }
            } else {
                icon.paintIcon(c, g2d, 0, 0);
            }
            g2d.translate(-this.paintIconR.x, -this.paintIconR.y);
        }
        ComponentState labelState = label.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float labelAlpha = SubstanceColorSchemeUtilities.getAlpha(label, labelState);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.paintTextR);
            } else {
                SubstanceTextUtilities.paintText(g, (JComponent)label, this.paintTextR, clippedText, label.getDisplayedMnemonicIndex(), labelState, labelAlpha);
            }
        }
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Component)c);
        this.paint(g2d, c);
        g2d.dispose();
    }
}

