/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class DecorationPainterUtils {
    private static final String DECORATION_AREA_TYPE = "substancelaf.internal.painter.decorationAreaType";
    public static final String POPUP_INVOKER_LINK = "substancelaf.internal.popupInvokerLink";

    public static void setDecorationType(JComponent comp, SubstanceSlices.DecorationAreaType type) {
        comp.putClientProperty(DECORATION_AREA_TYPE, type);
    }

    public static void clearDecorationType(JComponent comp) {
        if (comp != null) {
            comp.putClientProperty(DECORATION_AREA_TYPE, null);
        }
    }

    public static SubstanceSlices.DecorationAreaType getDecorationType(Component comp) {
        Component invoker;
        JPopupMenu popupMenu = null;
        JComponent popupInvoker = null;
        for (Component c = comp; c != null; c = c.getParent()) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                Object prop = jc.getClientProperty(DECORATION_AREA_TYPE);
                if (prop instanceof SubstanceSlices.DecorationAreaType) {
                    return (SubstanceSlices.DecorationAreaType)prop;
                }
                Object invokerProp = jc.getClientProperty(POPUP_INVOKER_LINK);
                if (invokerProp instanceof PopupInvokerLink) {
                    popupInvoker = ((PopupInvokerLink)invokerProp).getPopupInvoker();
                }
            }
            if (!(c instanceof JPopupMenu)) continue;
            popupMenu = (JPopupMenu)c;
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return DecorationPainterUtils.getDecorationType(popupMenu.getInvoker());
        }
        if (popupInvoker != null) {
            return DecorationPainterUtils.getDecorationType(popupInvoker);
        }
        return SubstanceSlices.DecorationAreaType.NONE;
    }

    public static SubstanceSlices.DecorationAreaType getImmediateDecorationType(Component comp) {
        JComponent jc;
        Object prop;
        Component c = comp;
        if (c instanceof JComponent && (prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof SubstanceSlices.DecorationAreaType) {
            return (SubstanceSlices.DecorationAreaType)prop;
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics g, Component c, boolean force) {
        SubstanceSlices.DecorationAreaType decorationType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c);
        DecorationPainterUtils.paintDecorationBackground(g, c, decorationType, force);
    }

    private static void paintDecorationBackground(Graphics g, Component c, SubstanceSlices.DecorationAreaType decorationType, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("substance.widget.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c.getHeight() == 0 || c.getWidth() == 0) {
            return;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        SubstanceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(g2d, c, 0, 0, c.getWidth(), c.getHeight());
            g2d.setComposite(WidgetUtilities.getAlphaComposite(c, 0.5f, g));
            painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        }
        g2d.dispose();
    }

    public static void paintDecorationArea(Graphics g, Component c, Shape contour, SubstanceSlices.DecorationAreaType decorationType, SubstanceColorScheme colorScheme, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("substance.widget.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c.getHeight() == 0 || c.getWidth() == 0) {
            return;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        SubstanceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, contour, colorScheme);
        g2d.dispose();
    }

    public static interface PopupInvokerLink {
        public JComponent getPopupInvoker();
    }
}

