/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.painterpack.fill;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class WaveFillPainter
implements SubstanceFillPainter {
    public String getDisplayName() {
        return "Wave";
    }

    public void paintContourBackground(Graphics g, Component comp, float width, float height, Shape contour, boolean isFocused, SubstanceColorScheme fillScheme, boolean hasShine) {
        double scale = NeonCortex.getScaleFactor((Component)comp);
        int iWidth = (int)Math.ceil(width);
        int iHeight = (int)Math.ceil(height);
        BufferedImage rectangular = SubstanceCoreUtilities.getBlankImage((double)scale, (int)iWidth, (int)iHeight);
        Graphics2D rgraphics = (Graphics2D)rectangular.getGraphics();
        Color lightFillColor = fillScheme.getUltraLightColor();
        Color midFillColor = fillScheme.getLightColor();
        Color darkFillColor = fillScheme.getMidColor();
        GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, lightFillColor, width / 4.0f, height / 2.0f, midFillColor);
        GeneralPath clipTop = new GeneralPath();
        clipTop.moveTo(0.0f, 0.0f);
        clipTop.lineTo(width, 0.0f);
        clipTop.curveTo(5.0f * width / 6.0f, height / 3.0f, 3.0f * width / 4.0f, height / 2.0f, width / 2.0f, height / 2.0f);
        clipTop.curveTo(width / 3.0f, height / 2.0f, width / 4.0f, height, 0.0f, 7.0f * height / 8.0f);
        clipTop.lineTo(0.0f, 0.0f);
        rgraphics.setClip(clipTop);
        rgraphics.setPaint(gradientTop);
        rgraphics.fillRect(0, 0, iWidth, iHeight);
        GradientPaint gradientBottom = new GradientPaint(2.0f * width / 3.0f, 2.0f * height / 3.0f, darkFillColor, width, height, midFillColor);
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5.0f * width / 6.0f, height / 3.0f, 3.0f * width / 4.0f, height / 2.0f, width / 2.0f, height / 2.0f);
        clipBottom.curveTo(width / 3.0f, height / 2.0f, width / 4.0f, height, 0.0f, 7.0f * height / 8.0f);
        clipBottom.lineTo(0.0f, height);
        rgraphics.setClip(clipBottom);
        rgraphics.setPaint(gradientBottom);
        rgraphics.fillRect(0, 0, iWidth, iHeight);
        rgraphics.setClip(null);
        GeneralPath mid = new GeneralPath();
        mid.moveTo(width, 0.0f);
        mid.curveTo(5.0f * width / 6.0f, height / 3.0f, 3.0f * width / 4.0f, height / 2.0f, width / 2.0f, height / 2.0f);
        mid.curveTo(width / 3.0f, height / 2.0f, width / 4.0f, height, 0.0f, 7.0f * height / 8.0f);
        rgraphics.draw(mid);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setClip(contour);
        graphics.drawImage((Image)rectangular, 0, 0, null);
        graphics.dispose();
    }
}

