/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.painterpack.fill;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.extras.api.colorschemepack.MixColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class MixDelegateFillPainter
implements SubstanceFillPainter {
    private String painterName;
    private SubstanceFillPainter delegate;

    public MixDelegateFillPainter(String painterName, SubstanceFillPainter delegate) {
        this.painterName = painterName;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintContourBackground(Graphics g, Component comp, float width, float height, Shape contour, boolean isFocused, SubstanceColorScheme fillScheme, boolean hasShine) {
        if (fillScheme instanceof MixColorScheme) {
            MixColorScheme mixColorScheme = (MixColorScheme)fillScheme;
            SubstanceColorScheme[] origSchemes = mixColorScheme.getOrigSchemes();
            double scale = NeonCortex.getScaleFactor((Component)comp);
            int iWidth = (int)Math.ceil(width);
            int iHeight = (int)Math.ceil(height);
            BufferedImage[] components = new BufferedImage[origSchemes.length];
            for (int i = 0; i < origSchemes.length; ++i) {
                components[i] = SubstanceCoreUtilities.getBlankImage((double)scale, (int)iWidth, (int)iHeight);
                Graphics2D g2d = components[i].createGraphics();
                this.delegate.paintContourBackground((Graphics)g2d, comp, width, height, contour, isFocused, origSchemes[i], hasShine);
                g2d.dispose();
            }
            BufferedImage current = components[0];
            for (int i = 1; i < components.length; ++i) {
                double start = ((double)i - 0.3) / (double)components.length;
                double end = ((double)i + 0.3) / (double)components.length;
                current = SubstanceCoreUtilities.blendImagesHorizontal((BufferedImage)current, (BufferedImage)components[i], (double)start, (double)end);
            }
            Graphics2D g2d = (Graphics2D)g.create();
            NeonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)current, (int)0, (int)0);
            g2d.dispose();
            return;
        }
        this.delegate.paintContourBackground(g, comp, width, height, contour, isFocused, fillScheme, hasShine);
    }
}

