/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.tabbed;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.extras.api.tabbed.TabPreviewPainter;
import org.pushingpixels.substance.extras.internal.tabbed.TabPagerManager;
import org.pushingpixels.substance.extras.internal.tabbed.TabPagerMouseWheelListener;
import org.pushingpixels.substance.extras.internal.tabbed.TabPreviewUtilities;

public class TabPagerWidget
extends SubstanceWidget<JTabbedPane> {
    protected MouseWheelListener mouseWheelListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;

    public void installUI() {
        super.installUI();
        if (TabPreviewUtilities.getTabPreviewPainter((JTabbedPane)this.jcomp) != null) {
            this.installMaps();
        }
    }

    private void installMaps() {
        InputMap currMap = SwingUtilities.getUIInputMap(this.jcomp, 1);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss = currMap.allKeys();
            for (int i = 0; i < kss.length; ++i) {
                KeyStroke stroke = kss[i];
                Object val = currMap.get(stroke);
                newMap.put(stroke, val);
            }
        }
        newMap.put(KeyStroke.getKeyStroke(39, 128), "tabSwitcherForward");
        newMap.put(KeyStroke.getKeyStroke(37, 128), "tabSwitcherBackward");
        newMap.put(KeyStroke.getKeyStroke(17, 0, true), "tabSwitcherClose");
        newMap.put(KeyStroke.getKeyStroke(27, 0), "tabSwitcherHide");
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherForward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPreviewPainter tpp = TabPreviewUtilities.getTabPreviewPainter((JTabbedPane)TabPagerWidget.this.jcomp);
                if (tpp == null) {
                    return;
                }
                TabPagerManager te = TabPagerManager.getPager();
                te.page((JTabbedPane)TabPagerWidget.this.jcomp, true);
            }
        });
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherBackward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPreviewPainter tpp = TabPreviewUtilities.getTabPreviewPainter((JTabbedPane)TabPagerWidget.this.jcomp);
                if (tpp == null) {
                    return;
                }
                TabPagerManager te = TabPagerManager.getPager();
                te.page((JTabbedPane)TabPagerWidget.this.jcomp, false);
            }
        });
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherClose", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> {
                    TabPreviewPainter tpp = TabPreviewUtilities.getTabPreviewPainter((JTabbedPane)TabPagerWidget.this.jcomp);
                    if (tpp == null) {
                        return;
                    }
                    TabPagerManager te = TabPagerManager.getPager();
                    int index = te.hide();
                    if (index >= 0 && tpp.isSensitiveToEvents((JTabbedPane)TabPagerWidget.this.jcomp, index)) {
                        ((JTabbedPane)TabPagerWidget.this.jcomp).setSelectedIndex(index);
                    }
                });
            }
        });
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherHide", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                if (te.isVisible()) {
                    te.hide();
                } else {
                    for (Container comp = ((JTabbedPane)TabPagerWidget.this.jcomp).getParent(); comp != null; comp = comp.getParent()) {
                        KeyStroke escapeKeyStroke;
                        JComponent jc;
                        ActionListener al;
                        if (!(comp instanceof JComponent) || (al = (jc = (JComponent)comp).getActionForKeyStroke(escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false))) == null) continue;
                        al.actionPerformed(e);
                        return;
                    }
                }
            }
        });
        SwingUtilities.replaceUIInputMap(this.jcomp, 1, newMap);
    }

    private void uninstallMaps() {
        InputMap currMap = SwingUtilities.getUIInputMap(this.jcomp, 1);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss = currMap.allKeys();
            for (int i = 0; i < kss.length; ++i) {
                KeyStroke stroke = kss[i];
                Object val = currMap.get(stroke);
                if (stroke.equals(KeyStroke.getKeyStroke(39, 128)) && "tabSwitcherForward".equals(val) || stroke.equals(KeyStroke.getKeyStroke(37, 128)) && "tabSwitcherBackward".equals(val) || stroke.equals(KeyStroke.getKeyStroke(17, 0, true)) && "tabSwitcherClose".equals(val) || stroke.equals(KeyStroke.getKeyStroke(27, 0)) && "tabSwitcherHide".equals(val)) continue;
                newMap.put(stroke, val);
            }
        }
        ((JTabbedPane)this.jcomp).getActionMap().remove("tabSwitcherForward");
        ((JTabbedPane)this.jcomp).getActionMap().remove("tabSwitcherBackward");
        ((JTabbedPane)this.jcomp).getActionMap().remove("tabSwitcherClose");
        ((JTabbedPane)this.jcomp).getActionMap().remove("tabSwitcherHide");
        SwingUtilities.replaceUIInputMap(this.jcomp, 1, newMap);
    }

    public void uninstallUI() {
        this.uninstallMaps();
        super.uninstallUI();
    }

    public void installListeners() {
        this.mouseWheelListener = new TabPagerMouseWheelListener((JTabbedPane)this.jcomp);
        ((JTabbedPane)this.jcomp).addMouseWheelListener(this.mouseWheelListener);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiersEx() & 0x80) != 0) {
                    SwingUtilities.invokeLater(() -> {
                        TabPagerManager te = TabPagerManager.getPager();
                        int index = te.hide();
                        if (index >= 0) {
                            ((JTabbedPane)TabPagerWidget.this.jcomp).setSelectedIndex(index);
                        }
                    });
                }
            }
        };
        ((JTabbedPane)this.jcomp).addMouseListener(this.mouseListener);
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("substance.extras.tabbedpanePreviewPainter".equals(propertyChangeEvent.getPropertyName())) {
                TabPreviewPainter oldValue = (TabPreviewPainter)propertyChangeEvent.getOldValue();
                TabPreviewPainter newValue = (TabPreviewPainter)propertyChangeEvent.getNewValue();
                if (oldValue == null && newValue != null) {
                    this.installMaps();
                }
                if (oldValue != null && newValue == null) {
                    this.uninstallMaps();
                }
            }
        };
        ((JTabbedPane)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallListeners() {
        ((JTabbedPane)this.jcomp).removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        ((JTabbedPane)this.jcomp).removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        ((JTabbedPane)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }
}

