/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.tabbed;

import java.awt.Insets;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.extras.api.tabbed.TabPreviewPainter;
import org.pushingpixels.substance.extras.internal.tabbed.TabOverviewButton;
import org.pushingpixels.substance.extras.internal.tabbed.TabPreviewUtilities;
import org.pushingpixels.substance.internal.ui.SubstanceTabbedPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class TabOverviewDialogWidget
extends SubstanceWidget<JTabbedPane> {
    protected TabOverviewButton overviewButton;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener containerListener;

    public void installComponents() {
        this.overviewButton = new TabOverviewButton((JTabbedPane)this.jcomp);
    }

    public void installDefaults() {
        TabPreviewPainter previewPainter = TabPreviewUtilities.getTabPreviewPainter((JTabbedPane)this.jcomp);
        if (previewPainter != null && previewPainter.hasOverviewDialog((JTabbedPane)this.jcomp)) {
            Insets currTabAreaInsets = this.getTabAreaInsets();
            if (currTabAreaInsets == null) {
                currTabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
            }
            Insets tabAreaInsets = new Insets(currTabAreaInsets.top, SubstanceSizeUtils.getLookupButtonSize() + 2 + currTabAreaInsets.left, currTabAreaInsets.bottom, currTabAreaInsets.right);
            this.setTabAreaInsets(tabAreaInsets);
            ((JTabbedPane)this.jcomp).add(this.overviewButton);
            this.overviewButton.setVisible(true);
            ((JTabbedPane)this.jcomp).setComponentZOrder(this.overviewButton, 0);
            this.overviewButton.updateLocation((JTabbedPane)this.jcomp, tabAreaInsets);
        }
    }

    public void uninstallComponents() {
        if (this.overviewButton.getParent() == this.jcomp) {
            ((JTabbedPane)this.jcomp).remove(this.overviewButton);
        }
    }

    public void installListeners() {
        this.propertyListener = propertyChangeEvent -> {
            Insets currTabAreaInsets;
            Insets lafInsets = this.getTabAreaInsets();
            Insets insets = currTabAreaInsets = lafInsets == null ? UIManager.getInsets("TabbedPane.tabAreaInsets") : lafInsets;
            if ("substance.extras.tabbedpanePreviewPainter".equals(propertyChangeEvent.getPropertyName())) {
                TabPreviewPainter previewPainter = TabPreviewUtilities.getTabPreviewPainter((JTabbedPane)this.jcomp);
                if (previewPainter != null && previewPainter.hasOverviewDialog((JTabbedPane)this.jcomp)) {
                    Insets tabAreaInsets = new Insets(currTabAreaInsets.top, SubstanceSizeUtils.getLookupButtonSize() + 2 + currTabAreaInsets.left, currTabAreaInsets.bottom, currTabAreaInsets.right);
                    this.setTabAreaInsets(tabAreaInsets);
                    ((JTabbedPane)this.jcomp).add(this.overviewButton);
                    this.overviewButton.setVisible(true);
                    this.overviewButton.updateLocation((JTabbedPane)this.jcomp, tabAreaInsets);
                } else {
                    ((JTabbedPane)this.jcomp).remove(this.overviewButton);
                }
            }
            if ("tabPlacement".equals(propertyChangeEvent.getPropertyName()) || "componentOrientation".equals(propertyChangeEvent.getPropertyName()) || "tabAreaInsets".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.overviewButton.getParent() == this.jcomp) {
                        this.overviewButton.updateLocation((JTabbedPane)this.jcomp, currTabAreaInsets);
                    }
                });
            }
        };
        ((JTabbedPane)this.jcomp).addPropertyChangeListener(this.propertyListener);
        this.containerListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                this.syncOverviewButtonVisibility();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                this.syncOverviewButtonVisibility();
            }

            private void syncOverviewButtonVisibility() {
                if (TabOverviewDialogWidget.this.overviewButton.getParent() != TabOverviewDialogWidget.this.jcomp) {
                    return;
                }
                TabOverviewDialogWidget.this.overviewButton.setVisible(((JTabbedPane)TabOverviewDialogWidget.this.jcomp).getTabCount() > 0);
            }
        };
        ((JTabbedPane)this.jcomp).addContainerListener(this.containerListener);
    }

    public void uninstallListeners() {
        ((JTabbedPane)this.jcomp).removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
        ((JTabbedPane)this.jcomp).removeContainerListener(this.containerListener);
        this.containerListener = null;
    }

    private Insets getTabAreaInsets() {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)((JTabbedPane)this.jcomp).getUI();
        return ui.getTabAreaInsets();
    }

    private void setTabAreaInsets(Insets tabAreaInsets) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)((JTabbedPane)this.jcomp).getUI();
        ui.setTabAreaInsets(tabAreaInsets);
    }
}

