/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.watermarkpack;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;

public class SubstanceCrosshatchWatermark
implements SubstanceWatermark {
    private static BufferedImage watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        NeonCortex.drawImage((Graphics)graphics, (Image)watermarkImage, (int)x, (int)y, (int)width, (int)height, (int)dx, (int)dy);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = NeonCortex.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = watermarkImage.createGraphics();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColorDark = null;
        Color stampColorAll = null;
        Color stampColorLight = null;
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        if (isPreview) {
            stampColorDark = scheme.isDark() ? Color.white : Color.black;
            stampColorAll = Color.lightGray;
            stampColorLight = scheme.isDark() ? Color.black : Color.white;
        } else {
            stampColorDark = scheme.getWatermarkDarkColor();
            stampColorAll = scheme.getWatermarkStampColor();
            stampColorLight = scheme.getWatermarkLightColor();
        }
        graphics.setColor(stampColorAll);
        graphics.fillRect(0, 0, width, height);
        BufferedImage tile = NeonCortex.getBlankUnscaledImage((int)4, (int)4);
        tile.setRGB(0, 0, stampColorDark.getRGB());
        tile.setRGB(2, 2, stampColorDark.getRGB());
        tile.setRGB(0, 1, stampColorLight.getRGB());
        tile.setRGB(2, 3, stampColorLight.getRGB());
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
        for (int row = y; row < y + height; row += 4) {
            for (int col = x; col < x + width; col += 4) {
                g2d.drawImage((Image)tile, col, row, null);
            }
        }
        g2d.dispose();
        return true;
    }

    public String getDisplayName() {
        return SubstanceCrosshatchWatermark.getName();
    }

    public static String getName() {
        return "Crosshatch";
    }

    public void dispose() {
        watermarkImage = null;
    }
}

