/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.watermarkpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;

public class SubstanceExceedWatermark
implements SubstanceWatermark {
    private static BufferedImage watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        NeonCortex.drawImage((Graphics)graphics, (Image)watermarkImage, (int)x, (int)y, (int)width, (int)height, (int)dx, (int)dy);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = NeonCortex.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = watermarkImage.createGraphics();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColorDark = null;
        Color stampColorLight = null;
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        if (isPreview) {
            stampColorDark = scheme.isDark() ? Color.white : Color.black;
            stampColorLight = scheme.isDark() ? Color.black : Color.white;
        } else {
            stampColorDark = scheme.getWatermarkDarkColor();
            stampColorLight = scheme.getWatermarkLightColor();
        }
        graphics.setColor(stampColorDark);
        graphics.fillRect(0, 0, width, height);
        BufferedImage tile = NeonCortex.getBlankUnscaledImage((int)4, (int)4);
        tile.setRGB(3, 0, stampColorLight.getRGB());
        tile.setRGB(2, 1, stampColorLight.getRGB());
        tile.setRGB(0, 2, stampColorLight.getRGB());
        tile.setRGB(1, 3, stampColorLight.getRGB());
        for (int row = y; row < y + height; row += 4) {
            for (int col = x; col < x + width; col += 4) {
                graphics.drawImage((Image)tile, col, row, null);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Exceed";
    }

    public void dispose() {
        watermarkImage = null;
    }
}

