/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.watermarkpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;

public class SubstanceBinaryWatermark
implements SubstanceWatermark {
    private static BufferedImage watermarkImage = null;
    private static int fontSize = 14;
    private static Font tahoma = new Font("Tahoma", 1, fontSize);
    private static Font tahomaPreview = new Font("Tahoma", 1, fontSize - 2);

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        NeonCortex.drawImage((Graphics)graphics, (Image)watermarkImage, (int)x, (int)y, (int)width, (int)height, (int)dx, (int)dy);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = NeonCortex.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = watermarkImage.createGraphics();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColor = null;
        int fontWidth = 0;
        int fontHeight = 0;
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        if (isPreview) {
            stampColor = scheme.isDark() ? Color.white : Color.black;
            graphics.setFont(tahomaPreview);
            fontWidth = fontSize - 6;
            fontHeight = fontSize - 4;
        } else {
            stampColor = scheme.getWatermarkStampColor();
            graphics.setFont(tahoma);
            fontWidth = fontSize - 4;
            fontHeight = fontSize - 2;
        }
        graphics.setColor(stampColor);
        int rows = height / fontHeight;
        int columns = width / fontWidth;
        for (int col = x; col <= x + columns; ++col) {
            for (int row = y; row <= y + rows; ++row) {
                double val = isPreview ? Math.abs(Math.sin(2.8 + (double)col + (double)(columns * row))) : Math.random();
                char c = val >= 0.5 ? (char)'0' : '1';
                graphics.drawString("" + c, col * fontWidth, fontHeight * (row + 1));
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Binary";
    }

    public void dispose() {
        watermarkImage = null;
    }
}

