/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.skinpack;

import java.awt.Color;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.CharcoalColorScheme;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunsetColorScheme;
import org.pushingpixels.substance.api.painter.border.GlassBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.ArcDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.GlassFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.extras.api.watermarkpack.SubstancePlanktonWatermark;
import org.pushingpixels.substance.internal.colorscheme.ShadeColorScheme;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;

public class MagmaSkin
extends SubstanceSkin {
    public static final String NAME = "Magma";

    public MagmaSkin() {
        ShiftColorScheme shiftRed = new ShiftColorScheme((SubstanceColorScheme)new SunsetColorScheme(), Color.red, 0.3);
        CharcoalColorScheme defaultScheme = new CharcoalColorScheme();
        SubstanceColorScheme activeScheme = shiftRed.saturate(0.4).named("Magma Active");
        SubstanceColorScheme disabledScheme = new ShadeColorScheme((SubstanceColorScheme)new CharcoalColorScheme(), 0.5){
            Color foreColor;
            {
                this.foreColor = new Color(104, 93, 90);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        }.named("Magma Disabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, (SubstanceColorScheme)defaultScheme, disabledScheme);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)new CharcoalColorScheme(), SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(activeScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        defaultSchemeBundle.registerAlpha(0.7f, new ComponentState[]{ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED});
        defaultSchemeBundle.registerColorScheme(disabledScheme, new ComponentState[]{ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED});
        defaultSchemeBundle.registerHighlightAlpha(0.7f, new ComponentState[]{ComponentState.ROLLOVER_UNSELECTED});
        defaultSchemeBundle.registerHighlightAlpha(0.7f, new ComponentState[]{ComponentState.SELECTED});
        defaultSchemeBundle.registerHighlightAlpha(0.9f, new ComponentState[]{ComponentState.ROLLOVER_SELECTED});
        defaultSchemeBundle.registerHighlightAlpha(0.7f, new ComponentState[]{ComponentState.ARMED, ComponentState.ROLLOVER_ARMED});
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme, new ComponentState[]{ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED});
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme.saturate(-0.2), new ComponentState[]{ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED});
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, new SubstanceSlices.DecorationAreaType[]{SubstanceSlices.DecorationAreaType.NONE});
        this.registerAsDecorationArea((SubstanceColorScheme)defaultScheme, new SubstanceSlices.DecorationAreaType[]{SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER, SubstanceSlices.DecorationAreaType.FOOTER, SubstanceSlices.DecorationAreaType.GENERAL, SubstanceSlices.DecorationAreaType.TOOLBAR});
        this.setTabFadeStart(1.0);
        this.setTabFadeEnd(1.0);
        this.watermarkScheme = defaultScheme.shade(0.5);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new GlassFillPainter();
        this.decorationPainter = new ArcDecorationPainter();
        this.watermark = new SubstancePlanktonWatermark();
        this.borderPainter = new GlassBorderPainter();
        this.highlightPainter = new ClassicHighlightPainter();
    }

    public String getDisplayName() {
        return NAME;
    }
}

