/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.shaperpack;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CanonicalPath {
    private ArrayList<Point2D> majorPoints;
    private ArrayList<Point2D> minorPoints;
    private double ratio;

    public CanonicalPath(ArrayList<Point2D> majorPoints, ArrayList<Point2D> minorPoints, double ratio) {
        if (majorPoints.size() != minorPoints.size()) {
            throw new IllegalArgumentException("Sizes of major and minor must be equal");
        }
        this.majorPoints = majorPoints;
        this.minorPoints = minorPoints;
        this.ratio = ratio;
    }

    public GeneralPath getPath(float width, float height, float insets) {
        GeneralPath path = new GeneralPath();
        if (this.majorPoints.size() < 2) {
            return path;
        }
        float xs = insets;
        float ys = insets;
        path.moveTo((float)((double)xs + (double)(width -= 2.0f * insets) * this.majorPoints.get(0).getX()), (float)((double)ys + (double)(height -= 2.0f * insets) * this.majorPoints.get(0).getY()));
        for (int i = 1; i < this.majorPoints.size(); ++i) {
            path.quadTo((double)xs + (double)width * this.minorPoints.get(i - 1).getX(), (double)ys + (double)height * this.minorPoints.get(i - 1).getY(), (double)xs + (double)width * this.majorPoints.get(i).getX(), (double)ys + (double)height * this.majorPoints.get(i).getY());
        }
        path.quadTo((double)xs + (double)width * this.minorPoints.get(this.minorPoints.size() - 1).getX(), (double)ys + (double)height * this.minorPoints.get(this.minorPoints.size() - 1).getY(), (double)xs + (double)width * this.majorPoints.get(0).getX(), (double)ys + (double)height * this.majorPoints.get(0).getY());
        return path;
    }

    public ArrayList<Point2D> getMajorPoints() {
        return this.majorPoints;
    }

    public ArrayList<Point2D> getMinorPoints() {
        return this.minorPoints;
    }

    public double getRatio() {
        return this.ratio;
    }
}

