/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.painterpack.noise;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.extras.api.painterpack.noise.NoiseFilter;
import org.pushingpixels.substance.internal.utils.PerlinNoiseGenerator;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class NoiseFactory {
    public static BufferedImage getNoiseImage(SubstanceSkin skin, int width, int height, double xFactor, double yFactor, boolean hasConstantZ, NoiseFilter noiseFilter, boolean toBlur, boolean isPreview) {
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        Color c1 = scheme.getWatermarkDarkColor();
        Color c3 = scheme.getWatermarkLightColor();
        BufferedImage dst = NeonCortex.getBlankImage((int)width, (int)height);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int imageWidth = dst.getWidth();
        int imageHeight = dst.getHeight();
        double m2 = xFactor * (double)imageWidth * xFactor * (double)imageWidth + yFactor * (double)imageHeight * yFactor * (double)imageHeight;
        int pos = 0;
        for (int j = 0; j < imageHeight; ++j) {
            double jj = yFactor * (double)j;
            for (int i = 0; i < imageWidth; ++i) {
                double ii = xFactor * (double)i;
                double z = hasConstantZ ? 1.0 : Math.sqrt(m2 - ii * ii - jj * jj);
                double noise = 0.5 + 0.5 * PerlinNoiseGenerator.noise((double)ii, (double)jj, (double)z);
                if (noiseFilter != null) {
                    noise = noiseFilter.apply(i, j, z, noise);
                }
                double likeness = Math.max(0.0, Math.min(1.0, 2.0 * noise));
                dstBuffer[pos++] = SubstanceColorUtilities.getInterpolatedRGB((Color)c3, (Color)c1, (double)likeness);
            }
        }
        if (toBlur) {
            float edgeBlur = 0.08f / (float)NeonCortex.getScaleFactor();
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{edgeBlur, edgeBlur, edgeBlur, edgeBlur, 1.06f - 8.0f * edgeBlur, edgeBlur, edgeBlur, edgeBlur, edgeBlur}), 1, null);
            dst = convolve.filter(dst, NeonCortex.getBlankImage((int)width, (int)height));
        }
        return dst;
    }
}

