/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.watermarkpack;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.extras.api.painterpack.noise.NoiseFactory;
import org.pushingpixels.substance.extras.api.painterpack.noise.NoiseFilter;

public class SubstanceNoiseWatermark
implements SubstanceWatermark {
    private BufferedImage watermarkImage = null;
    protected String displayName;
    protected double xFactor;
    protected double yFactor;
    protected boolean hasConstantZ;
    protected NoiseFilter noiseFilter;
    protected boolean toBlur;

    public SubstanceNoiseWatermark(String displayName, double xFactor, double yFactor, boolean hasConstantZ, NoiseFilter noiseFilter, boolean toBlur) {
        this.displayName = displayName;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
        this.hasConstantZ = hasConstantZ;
        this.noiseFilter = noiseFilter;
        this.toBlur = toBlur;
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        NeonCortex.drawImage((Graphics)graphics, (Image)this.watermarkImage, (int)x, (int)y, (int)width, (int)height, (int)dx, (int)dy);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        this.watermarkImage = NeonCortex.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = this.watermarkImage.createGraphics();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        if (isPreview) {
            graphics.drawImage((Image)NoiseFactory.getNoiseImage(skin, width, height, this.xFactor, this.yFactor, this.hasConstantZ, this.noiseFilter, this.toBlur, true), x, y, null);
        } else {
            int alpha = scheme.isDark() ? 200 : 140;
            graphics.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            graphics.drawImage((Image)NoiseFactory.getNoiseImage(skin, width, height, this.xFactor, this.yFactor, this.hasConstantZ, this.noiseFilter, this.toBlur, false), x, y, null);
        }
        return true;
    }

    public void dispose() {
        this.watermarkImage = null;
    }
}

