/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.common.CommandActionEvent;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceRibbonRootPaneUI;
import org.pushingpixels.neon.api.NeonCortex;

public class JRibbonRootPane
extends JRootPane {
    public static final String uiClassID = "RibbonRootPaneUI";

    public JRibbonRootPane() {
        this.updateUI();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.resetMaps();
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceRibbonRootPaneUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void resetMaps() {
        ActionMap actionMap = this.getActionMap();
        actionMap.clear();
        actionMap.put("toggleMinimized", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRibbon ribbon;
                JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(JRibbonRootPane.this);
                ribbon.setMinimized(!(ribbon = ribbonFrame.getRibbon()).isMinimized());
            }
        });
        InputMap inputMap = this.getInputMap(2);
        inputMap.clear();
        KeyStroke keyStroke = NeonCortex.getPlatform() == NeonCortex.Platform.MACOS ? KeyStroke.getKeyStroke("meta alt R") : KeyStroke.getKeyStroke("ctrl F1");
        inputMap.put(keyStroke, "toggleMinimized");
    }

    public void setKeyboardActions(Set<JRibbonFrame.RibbonKeyboardAction> actions) {
        this.resetMaps();
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        for (final JRibbonFrame.RibbonKeyboardAction action : actions) {
            actionMap.put(action.getActionName(), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Command command = action.getCommand();
                    if (command.isActionEnabled()) {
                        command.getAction().commandActivated(new CommandActionEvent(JRibbonRootPane.this, 1001, command, e.getActionCommand(), e.getWhen(), e.getModifiers()));
                    }
                }
            });
            inputMap.put(action.getActionKeyStroke(), action.getActionName());
        }
    }
}

