/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.NeonIcon;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;

public class CommandButtonLayoutManagerBigFixedLandscape
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize(JCommandButton commandButton) {
        return FlamingoUtilities.getScaledSize(32, commandButton.getFont().getSize(), 2.0, 4);
    }

    @Override
    public Dimension getPreferredSize(JCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((double)NeonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        JSeparator jsep = new JSeparator(1);
        int layoutVGap = FlamingoUtilities.getVLayoutGap(commandButton);
        int fillTitleWidth = fm.stringWidth(commandButton.getText());
        int widthFull = Math.max(this.getPreferredIconSize(commandButton), fillTitleWidth);
        int heightFull = by + this.getPreferredIconSize(commandButton) + layoutVGap + jsep.getPreferredSize().width;
        if (commandButton.getText() != null) {
            heightFull += fm.getHeight();
        }
        widthFull = Math.max(widthFull, heightFull * 5 / 4);
        return new Dimension(bx + widthFull, heightFull);
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        return new Point(layoutInfo.actionClickArea.x + layoutInfo.actionClickArea.width / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        return new Point(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int y = ins.top;
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((double)NeonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        result.isTextInActionArea = false;
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
        }
        JSeparator jsep = new JSeparator(1);
        NeonIcon buttonIcon = commandButton.getIcon();
        if (commandButton.getText() == null) {
            y = ins.top + (height - ins.top - ins.bottom - buttonIcon.getIconHeight()) / 2;
        }
        result.iconRect.x = (width - buttonIcon.getIconWidth()) / 2;
        result.iconRect.y = y;
        result.iconRect.width = buttonIcon.getIconWidth();
        result.iconRect.height = buttonIcon.getIconHeight();
        y += buttonIcon.getIconHeight();
        y += jsep.getPreferredSize().width;
        CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
        lineLayoutInfo.text = commandButton.getText();
        lineLayoutInfo.textRect = new Rectangle();
        int labelWidth = fm.stringWidth(commandButton.getText());
        lineLayoutInfo.textRect.x = ins.left + (width - labelWidth - ins.left - ins.right) / 2;
        lineLayoutInfo.textRect.y = y;
        lineLayoutInfo.textRect.width = labelWidth;
        lineLayoutInfo.textRect.height = labelHeight;
        result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
        result.textLayoutInfoList.add(lineLayoutInfo);
        return result;
    }
}

