/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.flamingo.internal.ui.ribbon.SequentialFocusTraversalPolicy;

public abstract class BasicBandControlPanelUI
extends AbstractBandControlPanelUI {
    private JSeparator[] groupSeparators;
    private JLabel[] groupLabels;
    private ChangeListener changeListener;

    @Override
    protected LayoutManager createLayoutManager() {
        return new ControlPanelLayout();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.changeListener = changeEvent -> {
            this.syncGroupHeaders();
            this.controlPanel.revalidate();
        };
        ((JBandControlPanel)this.controlPanel).addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        ((JBandControlPanel)this.controlPanel).removeChangeListener(this.changeListener);
        this.changeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncGroupHeaders();
    }

    @Override
    protected void uninstallComponents() {
        if (this.groupSeparators != null) {
            for (JComponent jComponent : this.groupSeparators) {
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            for (JComponent jComponent : this.groupLabels) {
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        super.uninstallComponents();
    }

    protected void syncGroupHeaders() {
        int i;
        int groupCount;
        if (this.groupSeparators != null) {
            for (JComponent jComponent : this.groupSeparators) {
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            for (JComponent jComponent : this.groupLabels) {
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        if ((groupCount = ((JBandControlPanel)this.controlPanel).getControlPanelGroupCount()) > 1) {
            this.groupSeparators = new JSeparator[groupCount - 1];
            for (i = 0; i < groupCount - 1; ++i) {
                this.groupSeparators[i] = new JSeparator(1);
                this.controlPanel.add(this.groupSeparators[i]);
            }
        }
        if (groupCount > 0) {
            this.groupLabels = new JLabel[groupCount];
            for (i = 0; i < groupCount; ++i) {
                String title = ((JBandControlPanel)this.controlPanel).getControlPanelGroupTitle(i);
                if (title == null) continue;
                this.groupLabels[i] = new JLabel(title);
                this.controlPanel.add(this.groupLabels[i]);
            }
        }
    }

    private class ControlPanelLayout
    implements LayoutManager {
        private ControlPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = BasicBandControlPanelUI.this.forSizing.getPreferredSize().height;
            int vGap = BasicBandControlPanelUI.this.getLayoutGap() * 3 / 4;
            int minusGaps = buttonHeight - 2 * vGap;
            switch (minusGaps % 3) {
                case 1: {
                    buttonHeight += 2;
                    break;
                }
                case 2: {
                    ++buttonHeight;
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth() + ins.left + ins.right, buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            AbstractRibbonBand ribbonBand = ((JBandControlPanel)c).getRibbonBand();
            RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
            if (currentResizePolicy == null) {
                return;
            }
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            Insets ins = c.getInsets();
            int gap = BasicBandControlPanelUI.this.getLayoutGap();
            int x = ltr ? ins.left + gap / 2 : c.getWidth() - ins.right - gap / 2;
            int availableHeight = c.getHeight() - ins.top - ins.bottom;
            if (SwingUtilities.getAncestorOfClass(BasicRibbonBandUI.CollapsedButtonPopupPanel.class, c) != null) {
                List<RibbonBandResizePolicy> resizePolicies = ribbonBand.getResizePolicies();
                resizePolicies.get(0).install(availableHeight, gap);
            } else {
                if (currentResizePolicy instanceof CoreRibbonResizePolicies.IconRibbonBandResizePolicy) {
                    return;
                }
                currentResizePolicy.install(availableHeight, gap);
            }
            ArrayList<Component> focusSequence = new ArrayList<Component>();
            int controlPanelGroupIndex = 0;
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)BasicBandControlPanelUI.this.controlPanel).getControlPanelGroups()) {
                if (controlPanelGroupIndex > 0) {
                    int prefW = ((BasicBandControlPanelUI)BasicBandControlPanelUI.this).groupSeparators[controlPanelGroupIndex - 1].getPreferredSize().width;
                    int sepX = ltr ? x - gap + (gap - prefW) / 2 : x + gap / 2 - (gap - prefW) / 2;
                    BasicBandControlPanelUI.this.groupSeparators[controlPanelGroupIndex - 1].setBounds(sepX, ins.top, prefW, availableHeight);
                }
                boolean hasLeadingComponent = false;
                boolean isCoreContent = controlPanelGroup.isCoreContent();
                if (isCoreContent) {
                    int startingRow;
                    int singleRowHeight = availableHeight / 3;
                    int hasTitle = controlPanelGroup.getGroupTitle() != null ? 1 : 0;
                    int maxWidthInCurrColumn = 0;
                    if (hasTitle != 0) {
                        int baseline;
                        JLabel titleLabel = BasicBandControlPanelUI.this.groupLabels[controlPanelGroupIndex];
                        int pw = titleLabel.getPreferredSize().width;
                        int titleLabelHeight = Math.min(singleRowHeight - gap / 4, titleLabel.getPreferredSize().height);
                        int yNudge = singleRowHeight - titleLabelHeight;
                        int n = baseline = titleLabelHeight > 0 ? titleLabel.getBaseline(pw, titleLabelHeight) : 0;
                        if (ltr) {
                            titleLabel.setBounds(x + gap, ins.top + yNudge - titleLabelHeight + baseline, pw, titleLabelHeight);
                        } else {
                            titleLabel.setBounds(x - gap - pw, ins.top + yNudge - titleLabelHeight + baseline, pw, titleLabelHeight);
                        }
                        maxWidthInCurrColumn = gap + pw;
                    }
                    List<JRibbonComponent> ribbonComps = controlPanelGroup.getRibbonComps();
                    ArrayList<JRibbonComponent> currColumn = new ArrayList<JRibbonComponent>();
                    int rowIndex = startingRow = hasTitle != 0 ? 1 : 0;
                    for (int i = 0; i < ribbonComps.size(); ++i) {
                        JRibbonComponent coreComp = ribbonComps.get(i);
                        int prefWidth = coreComp.getPreferredSize().width;
                        int rowSpan = 1;
                        int nextRowIndex = rowIndex + rowSpan;
                        if (nextRowIndex > 3) {
                            if (ltr) {
                                if (hasLeadingComponent) {
                                    x += gap;
                                }
                                x += maxWidthInCurrColumn;
                            } else {
                                if (hasLeadingComponent) {
                                    x -= gap;
                                }
                                x -= maxWidthInCurrColumn;
                            }
                            hasLeadingComponent = true;
                            maxWidthInCurrColumn = 0;
                            rowIndex = startingRow;
                            currColumn.clear();
                        }
                        int compHeight = Math.min(rowSpan * singleRowHeight - gap / 4, coreComp.getPreferredSize().height);
                        int yNudge = rowSpan * singleRowHeight - compHeight;
                        int y = rowIndex * singleRowHeight + ins.top;
                        if (ltr) {
                            coreComp.setBounds(x, y + yNudge, prefWidth, compHeight);
                        } else {
                            coreComp.setBounds(x - prefWidth, y + yNudge, prefWidth, compHeight);
                        }
                        focusSequence.add(coreComp.getMainComponent());
                        maxWidthInCurrColumn = Math.max(maxWidthInCurrColumn, prefWidth);
                        currColumn.add(coreComp);
                        coreComp.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", rowIndex == 0);
                        coreComp.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", rowIndex > 0 && rowIndex < 2);
                        coreComp.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", rowIndex == 2);
                        for (JRibbonComponent comp : currColumn) {
                            Rectangle bounds = comp.getBounds();
                            if (ltr) {
                                comp.setBounds(bounds.x, bounds.y, maxWidthInCurrColumn, bounds.height);
                            } else {
                                comp.setBounds(bounds.x + bounds.width - maxWidthInCurrColumn, bounds.y, maxWidthInCurrColumn, bounds.height);
                            }
                            comp.doLayout();
                        }
                        rowIndex += rowSpan;
                    }
                    if (rowIndex > 0 && rowIndex <= 3) {
                        if (ltr) {
                            if (hasLeadingComponent) {
                                x += gap;
                            }
                            x += maxWidthInCurrColumn;
                        } else {
                            if (hasLeadingComponent) {
                                x -= gap;
                            }
                            x -= maxWidthInCurrColumn;
                        }
                        hasLeadingComponent = true;
                    }
                } else {
                    for (JRibbonBand.PresentationPriority elementPriority : JRibbonBand.PresentationPriority.values()) {
                        for (JRibbonGallery gallery : controlPanelGroup.getRibbonGalleries(elementPriority)) {
                            int pw = gallery.getPreferredWidth(gallery.getPresentationPriority(), availableHeight);
                            if (ltr) {
                                gallery.setBounds(x, ins.top, pw, availableHeight);
                                if (hasLeadingComponent) {
                                    x += gap;
                                }
                                x += pw;
                            } else {
                                gallery.setBounds(x - pw, ins.top, pw, availableHeight);
                                if (hasLeadingComponent) {
                                    x -= gap;
                                }
                                x -= pw;
                            }
                            hasLeadingComponent = true;
                            for (int ci = 0; ci < gallery.getComponentCount(); ++ci) {
                                Component child = gallery.getComponent(ci);
                                if (child instanceof JCommandButtonStrip) {
                                    JCommandButtonStrip strip = (JCommandButtonStrip)child;
                                    for (int si = 0; si < strip.getButtonCount(); ++si) {
                                        focusSequence.add(strip.getButton(si));
                                    }
                                    continue;
                                }
                                focusSequence.add(child);
                            }
                        }
                    }
                    HashMap buttonMap = new HashMap();
                    for (JRibbonBand.PresentationPriority elementPriority : JRibbonBand.PresentationPriority.values()) {
                        for (JCommandButton commandButton : controlPanelGroup.getRibbonButtons(elementPriority)) {
                            CommandButtonPresentationState state = commandButton.getPresentationState();
                            if (buttonMap.get(state) == null) {
                                buttonMap.put(state, new ArrayList());
                            }
                            ((List)buttonMap.get(state)).add(commandButton);
                        }
                    }
                    List bigs = (List)buttonMap.get(CommandButtonPresentationState.BIG);
                    if (bigs != null) {
                        for (JCommandButton bigButton : bigs) {
                            int bigButtonWidth = bigButton.getPreferredSize().width;
                            if (hasLeadingComponent) {
                                x = ltr ? (x += gap) : (x -= gap);
                            }
                            if (ltr) {
                                bigButton.setBounds(x, ins.top, bigButtonWidth, availableHeight);
                            } else {
                                bigButton.setBounds(x - bigButtonWidth, ins.top, bigButtonWidth, availableHeight);
                            }
                            focusSequence.add(bigButton);
                            bigButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", Boolean.FALSE);
                            bigButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", Boolean.FALSE);
                            bigButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", Boolean.FALSE);
                            x = ltr ? (x += bigButtonWidth) : (x -= bigButtonWidth);
                            hasLeadingComponent = true;
                        }
                    }
                    int vGap = gap * 3 / 4;
                    int medSmallButtonHeight = (availableHeight - 2 * vGap) / 3;
                    int index3 = 0;
                    int maxWidth3 = 0;
                    List mediums = (List)buttonMap.get(CommandButtonPresentationState.MEDIUM);
                    if (mediums != null) {
                        for (JCommandButton mediumButton : mediums) {
                            int medWidth = mediumButton.getPreferredSize().width;
                            maxWidth3 = Math.max(maxWidth3, medWidth);
                            if (hasLeadingComponent && index3 == 0) {
                                x = ltr ? (x += gap) : (x -= gap);
                            }
                            int buttonTop = (medSmallButtonHeight + vGap) * index3;
                            int buttonBottom = (medSmallButtonHeight + vGap) * (index3 + 1) - vGap;
                            if (ltr) {
                                mediumButton.setBounds(x, ins.top + buttonTop, medWidth, buttonBottom - buttonTop);
                            } else {
                                mediumButton.setBounds(x - medWidth, ins.top + buttonTop, medWidth, buttonBottom - buttonTop);
                            }
                            focusSequence.add(mediumButton);
                            mediumButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", index3 == 0);
                            mediumButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", index3 == 1);
                            mediumButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", index3 == 2);
                            if (++index3 != 3) continue;
                            index3 = 0;
                            x = ltr ? (x += maxWidth3) : (x -= maxWidth3);
                            hasLeadingComponent = true;
                            maxWidth3 = 0;
                        }
                    }
                    if (maxWidth3 > 0) {
                        x = ltr ? (x += maxWidth3) : (x -= maxWidth3);
                        hasLeadingComponent = true;
                    }
                    index3 = 0;
                    maxWidth3 = 0;
                    List smalls = (List)buttonMap.get(CommandButtonPresentationState.SMALL);
                    if (smalls != null) {
                        for (JCommandButton smallButton : smalls) {
                            int lowWidth = smallButton.getPreferredSize().width;
                            maxWidth3 = Math.max(maxWidth3, lowWidth);
                            if (hasLeadingComponent && index3 == 0) {
                                x = ltr ? (x += gap) : (x -= gap);
                            }
                            int buttonTop = (medSmallButtonHeight + vGap) * index3;
                            int buttonBottom = (medSmallButtonHeight + vGap) * (index3 + 1) - vGap;
                            if (ltr) {
                                smallButton.setBounds(x, ins.top + buttonTop, lowWidth, buttonBottom - buttonTop);
                            } else {
                                smallButton.setBounds(x - lowWidth, ins.top + buttonTop, lowWidth, buttonBottom - buttonTop);
                            }
                            focusSequence.add(smallButton);
                            smallButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", index3 == 0);
                            smallButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", index3 == 1);
                            smallButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", index3 == 2);
                            if (++index3 != 3) continue;
                            index3 = 0;
                            x = ltr ? (x += maxWidth3) : (x -= maxWidth3);
                            hasLeadingComponent = true;
                            maxWidth3 = 0;
                        }
                    }
                    if (index3 < 3 && maxWidth3 > 0) {
                        x = ltr ? (x += maxWidth3) : (x -= maxWidth3);
                        hasLeadingComponent = true;
                    }
                }
                x = ltr ? (x += gap * 3 / 2) : (x -= gap * 3 / 2);
                ++controlPanelGroupIndex;
            }
            c.setFocusTraversalPolicyProvider(true);
            c.setFocusTraversalPolicy(new SequentialFocusTraversalPolicy(focusSequence));
        }
    }
}

