/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.CommandAction;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.PopupActionListener;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonListener;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.NeonIcon;
import org.pushingpixels.substance.api.SubstanceCortex;

public abstract class BasicCommandButtonUI
extends CommandButtonUI {
    protected JCommandButton commandButton;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener projectionPropertyChangeListener;
    private BasicCommandButtonListener basicPopupButtonListener;
    protected CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo;
    private ChangeListener actionPreviewChangeListener;
    private FocusListener focusListener;
    protected boolean isInnerFocusOnAction;
    public static final String DONT_DISPOSE_POPUPS = "flamingo.internal.commandButton.ui.dontDisposePopups";
    private CommandAction disposePopupsActionListener;
    private PopupActionListener popupActionListener;
    protected NeonIcon popupActionIcon;
    protected CommandButtonLayoutManager layoutManager;

    protected BasicCommandButtonUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.commandButton = (JCommandButton)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.layoutManager = this.commandButton.getPresentationState().createLayoutManager(this.commandButton);
        this.updateIconDimension();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.commandButton = null;
    }

    protected void installDefaults() {
        this.updateBorder();
        Font currFont = this.commandButton.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            this.commandButton.setFont(SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
        }
        this.syncIconDimension();
        this.commandButton.getActionMap().put("innerFocusChange", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicCommandButtonUI.this.toggleInnerFocus();
            }
        });
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 64);
        KeyStroke ctrlTab = KeyStroke.getKeyStroke(9, 128);
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke(9, 192);
        HashSet<KeyStroke> forwardFocusKeys = new HashSet<KeyStroke>();
        forwardFocusKeys.add(tab);
        this.commandButton.setFocusTraversalKeys(0, forwardFocusKeys);
        HashSet<KeyStroke> backwardFocusKeys = new HashSet<KeyStroke>();
        backwardFocusKeys.add(shiftTab);
        this.commandButton.setFocusTraversalKeys(1, backwardFocusKeys);
        InputMap inputMap = this.commandButton.getInputMap(0);
        inputMap.put(ctrlTab, "innerFocusChange");
        inputMap.put(ctrlShiftTab, "innerFocusChange");
        this.syncInitialInnerFocus();
    }

    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            int tb = (int)(this.commandButton.getVGapScaleFactor() * 4.0);
            int lr = (int)(this.commandButton.getHGapScaleFactor() * 6.0);
            this.commandButton.setBorder(new BorderUIResource.EmptyBorderUIResource(tb, lr, tb, lr));
        }
    }

    protected void installComponents() {
        this.updatePopupActionIcon();
        NeonIcon buttonIcon = this.commandButton.getIcon();
        if (buttonIcon instanceof AsynchronousLoading) {
            ((AsynchronousLoading)buttonIcon).addAsynchronousLoadListener(success -> {
                if (success && this.commandButton != null) {
                    this.commandButton.repaint();
                }
            });
        }
        this.popupActionIcon = this.createPopupActionIcon();
    }

    protected void installListeners() {
        this.basicPopupButtonListener = this.createButtonListener(this.commandButton);
        if (this.basicPopupButtonListener != null) {
            this.commandButton.addMouseListener(this.basicPopupButtonListener);
            this.commandButton.addMouseMotionListener(this.basicPopupButtonListener);
            this.commandButton.addFocusListener(this.basicPopupButtonListener);
            this.commandButton.addChangeListener(this.basicPopupButtonListener);
        }
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                Icon newIcon = (Icon)propertyChangeEvent.getNewValue();
                if (newIcon instanceof AsynchronousLoading) {
                    AsynchronousLoading async = (AsynchronousLoading)newIcon;
                    async.addAsynchronousLoadListener(success -> {
                        if (success && this.commandButton != null) {
                            this.syncIconDimension();
                            this.commandButton.repaint();
                        }
                    });
                    if (!async.isLoading()) {
                        this.syncIconDimension();
                        this.commandButton.repaint();
                    }
                } else {
                    this.syncIconDimension();
                    this.commandButton.revalidate();
                    this.commandButton.repaint();
                }
            }
            if ("commandButtonKind".equals(propertyChangeEvent.getPropertyName())) {
                this.updatePopupActionIcon();
            }
            if ("popupOrientationKind".equals(propertyChangeEvent.getPropertyName())) {
                this.updatePopupActionIcon();
            }
            if ("iconDimension".equals(propertyChangeEvent.getPropertyName())) {
                this.updateIconDimension();
            }
            if ("hgapScaleFactor".equals(propertyChangeEvent.getPropertyName())) {
                this.updateBorder();
            }
            if ("vgapScaleFactor".equals(propertyChangeEvent.getPropertyName())) {
                this.updateBorder();
            }
            if ("popupModel".equals(propertyChangeEvent.getPropertyName())) {
                PopupButtonModel oldModel = (PopupButtonModel)propertyChangeEvent.getOldValue();
                PopupButtonModel newModel = (PopupButtonModel)propertyChangeEvent.getNewValue();
                if (oldModel != null) {
                    oldModel.removePopupActionListener(this.popupActionListener);
                    this.popupActionListener = null;
                }
                if (newModel != null) {
                    this.popupActionListener = this.createPopupActionListener();
                    newModel.addPopupActionListener(this.popupActionListener);
                }
            }
            if ("presentationState".equals(propertyChangeEvent.getPropertyName())) {
                this.syncIconDimension();
                this.commandButton.invalidate();
                this.commandButton.revalidate();
                this.commandButton.doLayout();
            }
            if (this.layoutManager != null) {
                this.layoutManager.propertyChange(propertyChangeEvent);
            }
            if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                this.updatePopupActionIcon();
                this.commandButton.repaint();
            }
        };
        this.commandButton.addPropertyChangeListener(this.propertyChangeListener);
        Command command = (Command)this.commandButton.getProjection().getContentModel();
        this.projectionPropertyChangeListener = propertyChangeEvent -> {
            if ("text".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.setText((String)propertyChangeEvent.getNewValue());
            }
            if ("extraText".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.setExtraText((String)propertyChangeEvent.getNewValue());
            }
            if ("iconFactory".equals(propertyChangeEvent.getPropertyName())) {
                NeonIcon.Factory factory = (NeonIcon.Factory)propertyChangeEvent.getNewValue();
                this.commandButton.setIcon(factory != null ? factory.createNewIcon() : null);
            }
            if ("isToggleSelected".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.getActionModel().setSelected((Boolean)propertyChangeEvent.getNewValue());
                if (command.getToggleGroupModel() != null) {
                    command.getToggleGroupModel().setSelected(command, (Boolean)propertyChangeEvent.getNewValue());
                }
            }
            if ("action".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.removeCommandListener((CommandAction)propertyChangeEvent.getOldValue());
                this.commandButton.addCommandListener((CommandAction)propertyChangeEvent.getNewValue());
            }
            if ("actionPreview".equals(propertyChangeEvent.getPropertyName())) {
                this.syncActionPreview(command, (Command.CommandActionPreview)propertyChangeEvent.getNewValue());
            }
            if ("actionRichTooltip".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.setActionRichTooltip((RichTooltip)propertyChangeEvent.getNewValue());
            }
            if ("secondaryRichTooltip".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.setPopupRichTooltip((RichTooltip)propertyChangeEvent.getNewValue());
            }
            if ("isAutoRepeatAction".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.setAutoRepeatAction((Boolean)propertyChangeEvent.getNewValue());
            }
            if ("isFireActionOnRollover".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.setFireActionOnRollover((Boolean)propertyChangeEvent.getNewValue());
            }
            if ("isFireActionOnPress".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.getActionModel().setFireActionOnPress((Boolean)propertyChangeEvent.getNewValue());
            }
            if ("actionEnabled".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.getActionModel().setEnabled((Boolean)propertyChangeEvent.getNewValue());
                this.commandButton.repaint();
            }
            if ("secondaryEnabled".equals(propertyChangeEvent.getPropertyName())) {
                this.commandButton.getPopupModel().setEnabled((Boolean)propertyChangeEvent.getNewValue());
                this.commandButton.repaint();
            }
        };
        command.addPropertyChangeListener(this.projectionPropertyChangeListener);
        this.syncActionPreview(command, command.getActionPreview());
        this.disposePopupsActionListener = commandActionEvent -> {
            JCommandPopupMenu menu;
            boolean toDismiss;
            boolean bl = toDismiss = !Boolean.TRUE.equals(this.commandButton.getClientProperty(DONT_DISPOSE_POPUPS));
            if (toDismiss && (menu = (JCommandPopupMenu)SwingUtilities.getAncestorOfClass(JCommandPopupMenu.class, this.commandButton)) != null) {
                toDismiss = ((CommandPopupMenuPresentationModel)menu.getProjection().getPresentationModel()).isToDismissOnCommandActivation();
            }
            if (toDismiss) {
                if (SwingUtilities.getAncestorOfClass(JPopupPanel.class, this.commandButton) != null) {
                    SwingUtilities.invokeLater(() -> {
                        if (this.commandButton != null) {
                            this.commandButton.getActionModel().setPressed(false);
                            this.commandButton.getActionModel().setRollover(false);
                            this.commandButton.getActionModel().setArmed(false);
                        }
                    });
                }
                PopupPanelManager.defaultManager().hidePopups(null);
            }
        };
        this.commandButton.addCommandListener(this.disposePopupsActionListener);
        this.popupActionListener = this.createPopupActionListener();
        this.commandButton.getPopupModel().addPopupActionListener(this.popupActionListener);
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BasicCommandButtonUI.this.commandButton.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BasicCommandButtonUI.this.commandButton.repaint();
            }
        };
        this.commandButton.addFocusListener(this.focusListener);
    }

    protected NeonIcon createPopupActionIcon() {
        return null;
    }

    protected BasicCommandButtonListener createButtonListener(JCommandButton b) {
        return new BasicCommandButtonListener();
    }

    protected void installKeyboardActions() {
        if (this.basicPopupButtonListener != null) {
            this.basicPopupButtonListener.installKeyboardActions(this.commandButton);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
    }

    protected void uninstallListeners() {
        if (this.basicPopupButtonListener != null) {
            this.commandButton.removeMouseListener(this.basicPopupButtonListener);
            this.commandButton.removeMouseListener(this.basicPopupButtonListener);
            this.commandButton.removeMouseMotionListener(this.basicPopupButtonListener);
            this.commandButton.removeFocusListener(this.basicPopupButtonListener);
            this.commandButton.removeChangeListener(this.basicPopupButtonListener);
        }
        this.commandButton.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        ((Command)this.commandButton.getProjection().getContentModel()).removePropertyChangeListener(this.projectionPropertyChangeListener);
        this.projectionPropertyChangeListener = null;
        this.commandButton.removeCommandListener(this.disposePopupsActionListener);
        this.disposePopupsActionListener = null;
        this.commandButton.getPopupModel().removePopupActionListener(this.popupActionListener);
        this.popupActionListener = null;
        if (this.actionPreviewChangeListener != null) {
            this.commandButton.getActionModel().removeChangeListener(this.actionPreviewChangeListener);
        }
        this.commandButton.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    protected void uninstallKeyboardActions() {
        if (this.basicPopupButtonListener != null) {
            this.basicPopupButtonListener.uninstallKeyboardActions(this.commandButton);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.commandButton.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    private void updateIconDimension() {
        int dimension = this.commandButton.getIconDimension();
        if (dimension > 0) {
            this.commandButton.getIcon().setDimension(new Dimension(dimension, dimension));
            this.commandButton.setPresentationState(CommandButtonPresentationState.FIT_TO_ICON);
            this.commandButton.invalidate();
            this.commandButton.revalidate();
            this.commandButton.doLayout();
            this.commandButton.repaint();
        }
    }

    protected void updatePopupActionIcon() {
        JCommandButton button = this.commandButton;
        this.popupActionIcon = button.getCommandButtonKind().hasPopup() ? this.createPopupActionIcon() : null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JCommandButton button = (JCommandButton)c;
        return this.layoutManager.getPreferredSize(button);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo() {
        if (this.layoutInfo != null) {
            return this.layoutInfo;
        }
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton);
        return this.layoutInfo;
    }

    @Override
    public CommandButtonLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    protected int getLayoutGap() {
        Font font = this.commandButton.getFont();
        if (font == null) {
            font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        return (font.getSize() - 4) / 4;
    }

    protected boolean isPaintingSeparators() {
        PopupButtonModel popupModel = this.commandButton.getPopupModel();
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        boolean isPopupRollover = popupModel != null && popupModel.isRollover();
        return isActionRollover || isPopupRollover;
    }

    protected boolean isPaintingBackground() {
        PopupButtonModel popupModel = this.commandButton.getPopupModel();
        boolean isActionSelected = this.commandButton.getActionModel().isSelected();
        boolean isPopupSelected = popupModel != null && popupModel.isSelected();
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        boolean isPopupRollover = popupModel != null && popupModel.isRollover();
        boolean isPopupShowing = popupModel != null && popupModel.isPopupShowing();
        boolean isActionArmed = this.commandButton.getActionModel().isArmed();
        boolean isPopupArmed = popupModel != null && popupModel.isArmed();
        return isActionSelected || isPopupSelected || isActionRollover || isPopupRollover || isPopupShowing || isActionArmed || isPopupArmed || !this.commandButton.isFlat();
    }

    protected PopupActionListener createPopupActionListener() {
        return event -> this.processPopupAction();
    }

    public void processPopupAction() {
        JPopupPanel popupPanel;
        boolean wasPopupShowing = this.commandButton.getPopupModel().isPopupShowing();
        PopupPanelManager.defaultManager().hidePopups(this.commandButton);
        if (wasPopupShowing) {
            return;
        }
        PopupPanelCallback popupCallback = this.commandButton.getPopupCallback();
        JPopupPanel jPopupPanel = popupPanel = popupCallback != null ? popupCallback.getPopupPanel(this.commandButton) : null;
        if (popupPanel != null) {
            popupPanel.applyComponentOrientation(this.commandButton.getComponentOrientation());
            SwingUtilities.invokeLater(() -> {
                int ph;
                if (this.commandButton == null || popupPanel == null) {
                    return;
                }
                if (!this.commandButton.isShowing()) {
                    return;
                }
                popupPanel.doLayout();
                int x = 0;
                int y = 0;
                JPopupPanel.PopupPanelCustomizer customizer = popupPanel.getCustomizer();
                boolean ltr = this.commandButton.getComponentOrientation().isLeftToRight();
                if (customizer == null) {
                    switch (this.commandButton.getPopupOrientationKind()) {
                        case DOWNWARD: {
                            CommandButtonPresentationModel.PopupHorizontalGravity popupHorizontalGravity = this.commandButton.getPopupHorizontalGravity();
                            boolean isLeftAligned = ltr && popupHorizontalGravity == CommandButtonPresentationModel.PopupHorizontalGravity.START || !ltr && popupHorizontalGravity == CommandButtonPresentationModel.PopupHorizontalGravity.END;
                            x = isLeftAligned ? this.commandButton.getLocationOnScreen().x : this.commandButton.getLocationOnScreen().x + this.commandButton.getWidth() - popupPanel.getPreferredSize().width;
                            y = this.commandButton.getLocationOnScreen().y + this.commandButton.getSize().height;
                            break;
                        }
                        case SIDEWARD: {
                            x = ltr ? this.commandButton.getLocationOnScreen().x + this.commandButton.getWidth() : this.commandButton.getLocationOnScreen().x - popupPanel.getPreferredSize().width;
                            y = this.commandButton.getLocationOnScreen().y + this.getLayoutInfo().popupClickArea.y;
                        }
                    }
                } else {
                    Rectangle placementRect = customizer.getScreenBounds();
                    x = placementRect.x;
                    y = placementRect.y;
                }
                Rectangle scrBounds = this.commandButton.getGraphicsConfiguration().getBounds();
                int pw = popupPanel.getPreferredSize().width;
                if (x + pw > scrBounds.x + scrBounds.width) {
                    x = scrBounds.x + scrBounds.width - pw;
                }
                if (y + (ph = popupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                    y = scrBounds.y + scrBounds.height - ph;
                }
                if (customizer != null) {
                    Rectangle placementRect = customizer.getScreenBounds();
                    popupPanel.setPreferredSize(new Dimension(placementRect.width, placementRect.height));
                }
                Popup popup = PopupFactory.getSharedInstance().getPopup(this.commandButton, popupPanel, x, y);
                PopupPanelManager.defaultManager().addPopup(this.commandButton, popup, popupPanel);
            });
        }
    }

    private void syncIconDimension() {
        NeonIcon icon = this.commandButton.getIcon();
        CommandButtonPresentationState commandButtonState = this.commandButton.getPresentationState();
        this.layoutManager = commandButtonState.createLayoutManager(this.commandButton);
        if (icon == null) {
            return;
        }
        int maxHeight = this.layoutManager.getPreferredIconSize(this.commandButton);
        if (maxHeight < 0) {
            maxHeight = this.commandButton.getIcon().getIconHeight();
        }
        if (commandButtonState != CommandButtonPresentationState.FIT_TO_ICON) {
            Dimension newDim = new Dimension(maxHeight, maxHeight);
            icon.setDimension(newDim);
        }
    }

    private void syncActionPreview(final Command command, final Command.CommandActionPreview actionPreview) {
        if (this.actionPreviewChangeListener != null) {
            this.commandButton.getActionModel().removeChangeListener(this.actionPreviewChangeListener);
        }
        if (actionPreview != null) {
            this.actionPreviewChangeListener = new ChangeListener(){
                boolean wasRollover = false;

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean isRollover = BasicCommandButtonUI.this.commandButton.getActionModel().isRollover();
                    if (this.wasRollover && !isRollover) {
                        actionPreview.onCommandPreviewCanceled(command);
                    }
                    if (!this.wasRollover && isRollover) {
                        actionPreview.onCommandPreviewActivated(command);
                    }
                    this.wasRollover = isRollover;
                }
            };
            this.commandButton.getActionModel().addChangeListener(this.actionPreviewChangeListener);
        }
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint() {
        return this.layoutManager.getActionKeyTipAnchorCenterPoint(this.commandButton);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint() {
        return this.layoutManager.getPopupKeyTipAnchorCenterPoint(this.commandButton);
    }

    private void syncInitialInnerFocus() {
        switch (this.commandButton.getCommandButtonKind()) {
            case ACTION_ONLY: {
                this.isInnerFocusOnAction = true;
                break;
            }
            case POPUP_ONLY: {
                this.isInnerFocusOnAction = false;
                break;
            }
            default: {
                this.isInnerFocusOnAction = this.commandButton.getActionModel().isEnabled();
            }
        }
    }

    private void toggleInnerFocus() {
        JCommandButton.CommandButtonKind commandButtonKind = this.commandButton.getCommandButtonKind();
        if (commandButtonKind == JCommandButton.CommandButtonKind.ACTION_ONLY || commandButtonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            return;
        }
        if (!this.commandButton.getActionModel().isEnabled() || !this.commandButton.getPopupModel().isEnabled()) {
            return;
        }
        this.isInnerFocusOnAction = !this.isInnerFocusOnAction;
        this.commandButton.repaint();
    }

    @Override
    public boolean isInnerFocusOnAction() {
        return this.isInnerFocusOnAction;
    }

    @Override
    public void setInnerFocusOnAction(boolean innerFocusOnAction) {
        if (this.isInnerFocusOnAction != innerFocusOnAction) {
            this.isInnerFocusOnAction = innerFocusOnAction;
            this.commandButton.repaint();
        }
    }
}

