/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;

public class BasicCommandButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener {
    @Override
    public void focusLost(FocusEvent e) {
        JCommandButton b = (JCommandButton)e.getSource();
        b.getActionModel().setArmed(false);
        b.getActionModel().setPressed(false);
        PopupButtonModel popupModel = b.getPopupModel();
        popupModel.setPressed(false);
        popupModel.setArmed(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        JCommandButton b = (JCommandButton)e.getSource();
        b.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            JCommandButton b = (JCommandButton)e.getSource();
            JScrollablePanel scrollable = (JScrollablePanel)SwingUtilities.getAncestorOfClass(JScrollablePanel.class, b);
            if (scrollable != null) {
                Point loc = SwingUtilities.convertPoint(b.getParent(), b.getLocation(), scrollable.getView());
                if (scrollable.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                    scrollable.scrollToIfNecessary(loc.x, b.getWidth());
                } else {
                    scrollable.scrollToIfNecessary(loc.y, b.getHeight());
                }
            }
            if (b.contains(e.getX(), e.getY())) {
                PopupButtonModel popupModel;
                CommandButtonUI ui = b.getUI();
                Rectangle actionRect = ui.getLayoutInfo().actionClickArea;
                Rectangle popupRect = ui.getLayoutInfo().popupClickArea;
                if (actionRect != null && actionRect.contains(e.getPoint())) {
                    ActionButtonModel actionModel = b.getActionModel();
                    if (actionModel.isEnabled()) {
                        actionModel.setArmed(true);
                        actionModel.setPressed(true);
                    }
                } else if (popupRect != null && popupRect.contains(e.getPoint()) && (popupModel = b.getPopupModel()).isEnabled()) {
                    popupModel.setArmed(true);
                    popupModel.setPressed(true);
                }
                if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                    b.requestFocusInWindow();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            JCommandButton b = (JCommandButton)e.getSource();
            b.getActionModel().setPressed(false);
            b.getPopupModel().setPressed(false);
            b.getActionModel().setArmed(false);
            b.getPopupModel().setArmed(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.syncMouseMovement(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.syncMouseMovement(e);
    }

    private void syncMouseMovement(MouseEvent e) {
        JCommandButton b = (JCommandButton)e.getSource();
        ActionButtonModel actionModel = b.getActionModel();
        PopupButtonModel popupModel = b.getPopupModel();
        CommandButtonUI ui = b.getUI();
        Rectangle actionRect = ui.getLayoutInfo().actionClickArea;
        Rectangle popupRect = ui.getLayoutInfo().popupClickArea;
        if (actionRect != null && actionRect.contains(e.getPoint())) {
            if (actionModel.isEnabled()) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    actionModel.setRollover(true);
                }
                if (actionModel.isPressed()) {
                    actionModel.setArmed(true);
                }
            }
            if (popupModel != null && !SwingUtilities.isLeftMouseButton(e)) {
                popupModel.setRollover(false);
            }
        } else if (popupRect != null && popupRect.contains(e.getPoint())) {
            if (popupModel != null && popupModel.isEnabled()) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    popupModel.setRollover(true);
                }
                if (popupModel.isPressed()) {
                    popupModel.setArmed(true);
                }
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                actionModel.setRollover(false);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JCommandButton b = (JCommandButton)e.getSource();
        ActionButtonModel actionModel = b.getActionModel();
        PopupButtonModel popupModel = b.getPopupModel();
        actionModel.setRollover(false);
        actionModel.setArmed(false);
        if (popupModel != null) {
            popupModel.setRollover(false);
            popupModel.setArmed(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JCommandButton b = (JCommandButton)e.getSource();
        b.repaint();
    }

    public void installKeyboardActions(JCommandButton button) {
        ActionMap actionMap = new ActionMap();
        actionMap.put("press", new PressAction(button));
        actionMap.put("release", new ReleaseAction(button));
        actionMap.put("popupDismiss", new PopupDismissAction(button));
        actionMap.put("popupToggle", new PopupToggleAction(button));
        actionMap.put("focusHome", new FocusHomeAction(button));
        actionMap.put("focusEnd", new FocusEndAction(button));
        actionMap.put("focusUp", new FocusUpAction(button));
        actionMap.put("focusDown", new FocusDownAction(button));
        actionMap.put("focusRight", new FocusRightAction(button));
        actionMap.put("focusLeft", new FocusLeftAction(button));
        SwingUtilities.replaceUIActionMap(button, actionMap);
        InputMap focusedInputMap = LookAndFeel.makeInputMap(new Object[]{"SPACE", "press", "released SPACE", "release", "ENTER", "press", "released ENTER", "release", "DOWN", "focusDown", "KP_DOWN", "focusDown", "UP", "focusUp", "KP_UP", "focusUp", "LEFT", "focusLeft", "KP_LEFT", "focusLeft", "RIGHT", "focusRight", "KP_RIGHT", "focusRight"});
        SwingUtilities.replaceUIInputMap(button, 0, focusedInputMap);
        InputMap ancestorOfFocusedInputMap = LookAndFeel.makeInputMap(new Object[]{"ESCAPE", "popupDismiss", "alt DOWN", "popupToggle", "alt KP_DOWN", "popupToggle", "alt UP", "popupToggle", "alt KP_UP", "popupToggle", "HOME", "focusHome", "END", "focusEnd"});
        SwingUtilities.replaceUIInputMap(button, 1, ancestorOfFocusedInputMap);
    }

    public void uninstallKeyboardActions(JCommandButton button) {
        SwingUtilities.replaceUIInputMap(button, 2, null);
        SwingUtilities.replaceUIInputMap(button, 1, null);
        SwingUtilities.replaceUIInputMap(button, 0, null);
        SwingUtilities.replaceUIActionMap(button, null);
    }

    private static class FocusLeftAction
    extends FocusTraversalAction {
        private static final String FOCUS_LEFT = "focusLeft";

        FocusLeftAction(JCommandButton button) {
            super(FOCUS_LEFT, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusLeft();
            }
        }
    }

    private static class FocusRightAction
    extends FocusTraversalAction {
        private static final String FOCUS_RIGHT = "focusRight";

        FocusRightAction(JCommandButton button) {
            super(FOCUS_RIGHT, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusRight();
            }
        }
    }

    private static class FocusDownAction
    extends FocusTraversalAction {
        private static final String FOCUS_DOWN = "focusDown";

        FocusDownAction(JCommandButton button) {
            super(FOCUS_DOWN, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusDown();
            }
        }
    }

    private static class FocusUpAction
    extends FocusTraversalAction {
        private static final String FOCUS_UP = "focusUp";

        FocusUpAction(JCommandButton button) {
            super(FOCUS_UP, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusUp();
            }
        }
    }

    private static class FocusEndAction
    extends FocusTraversalAction {
        private static final String FOCUS_END = "focusEnd";

        FocusEndAction(JCommandButton button) {
            super(FOCUS_END, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusLast();
            }
        }
    }

    private static class FocusHomeAction
    extends FocusTraversalAction {
        private static final String FOCUS_HOME = "focusHome";

        FocusHomeAction(JCommandButton button) {
            super(FOCUS_HOME, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusFirst();
            }
        }
    }

    private static abstract class FocusTraversalAction
    extends ButtonAction {
        FocusTraversalAction(String actionName, JCommandButton button) {
            super(actionName, button);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        protected JPopupPanel getPopup() {
            JPopupPanel popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, this.button);
            if (popupPanel != null) {
                return popupPanel;
            }
            PopupPanelManager popupPanelManager = PopupPanelManager.defaultManager();
            for (PopupPanelManager.PopupInfo popupInfo : popupPanelManager.getShownPath()) {
                if (popupInfo.getPopupOriginator() != this.button) continue;
                return popupInfo.getPopupPanel();
            }
            return null;
        }
    }

    private static class PopupToggleAction
    extends ButtonAction {
        private static final String TOGGLE = "popupToggle";

        PopupToggleAction(JCommandButton button) {
            super(TOGGLE, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.button.getUI().isInnerFocusOnAction()) {
                PopupButtonModel model = this.button.getPopupModel();
                if (PopupPanelManager.defaultManager().getShownPath().isEmpty()) {
                    model.setArmed(true);
                    model.setPressed(true);
                } else {
                    PopupPanelManager.defaultManager().hidePopups(null);
                    model.setArmed(false);
                    model.setPressed(false);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return this.button.getPopupModel().isEnabled();
        }
    }

    private static class PopupDismissAction
    extends ButtonAction {
        private static final String DISMISS = "popupDismiss";

        PopupDismissAction(JCommandButton button) {
            super(DISMISS, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private static class ReleaseAction
    extends ButtonAction {
        private static final String RELEASE = "release";

        ReleaseAction(JCommandButton button) {
            super(RELEASE, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonModel model = this.button.getUI().isInnerFocusOnAction() ? this.button.getActionModel() : this.button.getPopupModel();
            model.setPressed(false);
            model.setArmed(false);
        }

        @Override
        public boolean isEnabled() {
            return this.button.getActionModel().isEnabled();
        }
    }

    private static class PressAction
    extends ButtonAction {
        private static final String PRESS = "press";

        PressAction(JCommandButton button) {
            super(PRESS, button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonModel model = this.button.getUI().isInnerFocusOnAction() ? this.button.getActionModel() : this.button.getPopupModel();
            model.setArmed(true);
            model.setPressed(true);
            if (!this.button.hasFocus()) {
                this.button.requestFocus();
            }
        }

        @Override
        public boolean isEnabled() {
            return this.button.getActionModel().isEnabled();
        }
    }

    private static abstract class ButtonAction
    extends AbstractAction {
        protected final JCommandButton button;

        ButtonAction(String actionName, JCommandButton button) {
            super(actionName);
            this.button = button;
        }
    }
}

