/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.utils;

import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;

public class CommandButtonVisualStateTracker {
    private PropertyChangeListener substancePropertyListener;
    private StateTransitionTracker actionStateTransitionTracker;
    private StateTransitionTracker popupStateTransitionTracker;

    public void installListeners(JCommandButton b) {
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("actionModel".equals(propertyChangeEvent.getPropertyName())) {
                this.actionStateTransitionTracker.setModel((ButtonModel)b.getActionModel());
            }
            if ("popupModel".equals(propertyChangeEvent.getPropertyName())) {
                this.popupStateTransitionTracker.setModel((ButtonModel)b.getPopupModel());
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.actionStateTransitionTracker = new StateTransitionTracker((JComponent)b, (ButtonModel)b.getActionModel());
        this.actionStateTransitionTracker.registerModelListeners();
        this.popupStateTransitionTracker = new StateTransitionTracker((JComponent)b, (ButtonModel)b.getPopupModel());
        this.popupStateTransitionTracker.registerModelListeners();
    }

    public void uninstallListeners(JCommandButton b) {
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.actionStateTransitionTracker.unregisterModelListeners();
        this.actionStateTransitionTracker = null;
        if (this.popupStateTransitionTracker != null) {
            this.popupStateTransitionTracker.unregisterModelListeners();
            this.popupStateTransitionTracker = null;
        }
    }

    public StateTransitionTracker getActionStateTransitionTracker() {
        return this.actionStateTransitionTracker;
    }

    public StateTransitionTracker getPopupStateTransitionTracker() {
        return this.popupStateTransitionTracker;
    }
}

