/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.NeonIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

@TransitionAware
public class TransitionAwareNeonIcon
implements NeonIcon {
    protected int width;
    protected int height;
    private JComponent comp;
    private StateTransitionTrackerDelegate stateTransitionTrackerDelegate;
    private Delegate delegate;
    private LazyResettableHashMap<NeonIcon> iconMap;

    public TransitionAwareNeonIcon(JCommandButton button, StateTransitionTrackerDelegate stateTransitionTrackerDelegate, Delegate delegate, Dimension initialDim) {
        this.comp = button;
        this.stateTransitionTrackerDelegate = stateTransitionTrackerDelegate;
        this.delegate = delegate;
        this.iconMap = new LazyResettableHashMap("TransitionAwareNeonIcon");
        this.width = initialDim.width;
        this.height = initialDim.height;
    }

    private NeonIcon getIconToPaint() {
        double scale = NeonCortex.getScaleFactor((Component)this.comp);
        StateTransitionTracker stateTransitionTracker = this.stateTransitionTrackerDelegate.getStateTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme baseScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.comp, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.MARK, (ComponentState)currState);
        float baseAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.comp, (ComponentState)currState);
        ImageHashMapKey keyBase = SubstanceCoreUtilities.getScaleAwareHashKey((double)scale, (Object[])new Object[]{baseScheme.getDisplayName(), Float.valueOf(baseAlpha), this.width, this.height});
        NeonIcon layerBase = (NeonIcon)this.iconMap.get((LazyResettableHashMap.Key)keyBase);
        if (layerBase == null) {
            NeonIcon baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme, this.width, this.height);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                this.iconMap.put((LazyResettableHashMap.Key)keyBase, (Object)layerBase);
            } else {
                BufferedImage baseImage = SubstanceCoreUtilities.getBlankImage((double)scale, (int)baseFullOpacity.getIconWidth(), (int)baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon((Component)this.comp, (Graphics)g2base, 0, 0);
                g2base.dispose();
                layerBase = new ScaleAwareImageWrapperIcon(baseImage, scale);
                this.iconMap.put((LazyResettableHashMap.Key)keyBase, (Object)layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((double)scale, (int)layerBase.getIconWidth(), (int)layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        layerBase.paintIcon((Component)this.comp, (Graphics)g2d, 0, 0);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == currState || !((stateContribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.comp, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.MARK, (ComponentState)activeState);
            float alpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.comp, (ComponentState)activeState);
            ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey((double)scale, (Object[])new Object[]{scheme.getDisplayName(), Float.valueOf(alpha), this.width, this.height});
            NeonIcon layer = (NeonIcon)this.iconMap.get((LazyResettableHashMap.Key)key);
            if (layer == null) {
                NeonIcon fullOpacity = this.delegate.getColorSchemeIcon(scheme, this.width, this.height);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    this.iconMap.put((LazyResettableHashMap.Key)key, (Object)layer);
                } else {
                    BufferedImage image = SubstanceCoreUtilities.getBlankImage((double)scale, (int)fullOpacity.getIconWidth(), (int)fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon((Component)this.comp, (Graphics)g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new ScaleAwareImageWrapperIcon(image, scale);
                    this.iconMap.put((LazyResettableHashMap.Key)key, (Object)layer);
                }
            }
            layer.paintIcon((Component)this.comp, (Graphics)g2d, 0, 0);
        }
        g2d.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public boolean supportsColorFilter() {
        return false;
    }

    public void setColorFilter(NeonIcon.ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public static interface StateTransitionTrackerDelegate {
        public StateTransitionTracker getStateTransitionTracker();
    }

    @FunctionalInterface
    public static interface Delegate {
        public NeonIcon getColorSchemeIcon(SubstanceColorScheme var1, int var2, int var3);
    }
}

