/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.NeonIcon;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class GlowingNeonIcon
implements NeonIcon {
    private Map<String, BufferedImage> cachedImages;
    private NeonIcon delegate;
    private IconGlowTracker iconGlowTracker;

    public GlowingNeonIcon(NeonIcon delegate, IconGlowTracker iconGlowTracker) {
        this.delegate = delegate;
        this.iconGlowTracker = iconGlowTracker;
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public boolean supportsColorFilter() {
        return this.delegate.supportsColorFilter();
    }

    public void setColorFilter(NeonIcon.ColorFilter colorFilter) {
        this.delegate.setColorFilter(colorFilter);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d;
        float fadePos;
        if (this.delegate == null) {
            return;
        }
        double scale = NeonCortex.getScaleFactor((Component)c);
        String key = scale + ":" + (fadePos = this.iconGlowTracker.getIconGlowPosition()) + ":" + this.getIconWidth() + ":" + this.getIconHeight();
        if (!this.cachedImages.containsKey(key)) {
            AsynchronousLoading asyncDelegate;
            if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)this.delegate).isLoading()) {
                return;
            }
            BufferedImage offscreen = SubstanceCoreUtilities.getBlankImage((double)scale, (int)this.getIconWidth(), (int)this.getIconHeight());
            g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, (Graphics)g2d, 0, 0);
            g2d.dispose();
            int pixelWidth = offscreen.getWidth();
            int pixelHeight = offscreen.getHeight();
            for (int i = 0; i < pixelWidth; ++i) {
                for (int j = 0; j < pixelHeight; ++j) {
                    int rgba = offscreen.getRGB(i, j);
                    int transp = rgba >>> 24 & 0xFF;
                    double coef = Math.sin(Math.PI * 2 * (double)fadePos / 2.0) / 3.0;
                    Color newColor = coef >= 0.0 ? SubstanceColorUtilities.getLighterColor((Color)new Color(rgba), (double)coef) : SubstanceColorUtilities.getDarkerColor((Color)new Color(rgba), (double)(-coef));
                    offscreen.setRGB(i, j, transp << 24 | newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue());
                }
            }
            this.cachedImages.put(key, offscreen);
        }
        BufferedImage toDraw = this.cachedImages.get(key);
        g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        NeonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)toDraw, (int)0, (int)0);
        g2d.dispose();
    }
}

