/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.AbstractPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.CommandPopupMenuProjection;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.DefaultRibbonTaskbarKeyTipPolicy;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.RibbonTaskbarKeyTipPolicy;
import org.pushingpixels.flamingo.api.ribbon.model.RibbonGalleryContentModel;
import org.pushingpixels.flamingo.api.ribbon.model.RibbonTaskbarCommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonApplicationMenuCommandButtonProjection;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonTaskbarCommandButtonProjection;
import org.pushingpixels.flamingo.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.flamingo.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.RibbonApplicationMenuProjection;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class JRibbon
extends JComponent {
    private ArrayList<RibbonTask> tasks = new ArrayList();
    private ArrayList<RibbonContextualTaskGroup> contextualTaskGroups = new ArrayList();
    private ArrayList<Component> taskbarComponents = new ArrayList();
    private Map<RibbonGalleryContentModel, JCommandButton> taskbarGalleryMap;
    private Map<Command, JCommandButton> taskbarCommandMap = new HashMap<Command, JCommandButton>();
    private ArrayList<AbstractRibbonBand> bands;
    private RibbonTask currentlySelectedTask = null;
    private ArrayList<CommandButtonProjection> anchoredCommands;
    private Map<RibbonContextualTaskGroup, Boolean> groupVisibilityMap;
    private RibbonApplicationMenuCommandButtonProjection applicationMenuCommandProjection;
    private RibbonApplicationMenuProjection applicationMenuProjection;
    private boolean isMinimized;
    private JRibbonFrame ribbonFrame;
    private OnShowContextualMenuListener onShowContextualMenuListener;
    private List<OnTaskSelectionChangeListener> onTaskSelectionChangeListeners;
    private RibbonTaskbarKeyTipPolicy taskbarKeyTipPolicy;
    public static final String uiClassID = "RibbonUI";

    public JRibbon() {
        this.taskbarGalleryMap = new HashMap<RibbonGalleryContentModel, JCommandButton>();
        this.bands = new ArrayList();
        this.groupVisibilityMap = new HashMap<RibbonContextualTaskGroup, Boolean>();
        this.anchoredCommands = new ArrayList();
        this.taskbarKeyTipPolicy = new DefaultRibbonTaskbarKeyTipPolicy();
        this.updateUI();
    }

    JRibbon(JRibbonFrame ribbonFrame) {
        this();
        this.ribbonFrame = ribbonFrame;
    }

    public void setTaskbarKeyTipPolicy(RibbonTaskbarKeyTipPolicy taskbarKeyTipPolicy) {
        if (taskbarKeyTipPolicy == null) {
            throw new IllegalArgumentException("Cannot pass null policy");
        }
        this.taskbarKeyTipPolicy = taskbarKeyTipPolicy;
    }

    public RibbonTaskbarKeyTipPolicy getTaskbarKeyTipPolicy() {
        return this.taskbarKeyTipPolicy;
    }

    public synchronized void addTaskbarCommand(RibbonTaskbarCommandButtonProjection projection) {
        CommandButtonPresentationModel presentationModel = CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL).setIconFilterStrategies(((RibbonTaskbarCommandButtonPresentationModel)projection.getPresentationModel()).getActiveIconFilterStrategy(), ((RibbonTaskbarCommandButtonPresentationModel)projection.getPresentationModel()).getEnabledIconFilterStrategy(), ((RibbonTaskbarCommandButtonPresentationModel)projection.getPresentationModel()).getDisabledIconFilterStrategy()).setHorizontalGapScaleFactor(0.5).setVerticalGapScaleFactor(0.5).setPopupMenuPresentationModel(((RibbonTaskbarCommandButtonPresentationModel)projection.getPresentationModel()).getPopupMenuPresentationModel()).build();
        CommandButtonProjection<Command> commandButtonProjection = ((Command)projection.getContentModel()).project(presentationModel);
        JCommandButton commandButton = (JCommandButton)commandButtonProjection.buildComponent();
        commandButton.putClientProperty("radiance.flamingo.internal.ribbon.taskbarProjection", projection);
        this.taskbarComponents.add(commandButton);
        this.taskbarCommandMap.put((Command)projection.getContentModel(), commandButton);
        this.fireStateChanged();
    }

    public synchronized boolean isShowingInTaskbar(Command command) {
        return this.taskbarCommandMap.containsKey(command);
    }

    public synchronized void removeTaskbarCommand(Command command) {
        JCommandButton existing = this.taskbarCommandMap.get(command);
        if (existing != null) {
            this.taskbarComponents.remove(existing);
            this.taskbarCommandMap.remove(command);
            this.fireStateChanged();
        }
    }

    public synchronized void addTaskbarAppMenuLink(Command appMenuCommand) {
        if (this.applicationMenuProjection == null) {
            throw new IllegalArgumentException("Can't add app menu link when app menu is not set");
        }
        RibbonApplicationMenu ribbonApplicationMenu = (RibbonApplicationMenu)this.applicationMenuProjection.getContentModel();
        if (ribbonApplicationMenu == null) {
            throw new IllegalArgumentException("Can't add app menu link when app menu is not set");
        }
        if (!ribbonApplicationMenu.getFooterCommands().getCommands().contains(appMenuCommand) && !FlamingoUtilities.existsInMenu(appMenuCommand, ribbonApplicationMenu)) {
            throw new IllegalArgumentException("Command not found in app menu");
        }
        Command clone = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(appMenuCommand.getText())).setIconFactory(appMenuCommand.getIconFactory())).setAction(commandActionEvent -> {
            this.getUI().getApplicationMenuButton().doPopupClick();
            SwingUtilities.invokeLater(() -> {
                List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                if (popups.size() > 0) {
                    PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                    JPopupPanel popupPanel = last.getPopupPanel();
                    if (!(popupPanel instanceof JRibbonApplicationMenuPopupPanel)) {
                        return;
                    }
                    JRibbonApplicationMenuPopupPanel appMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)popupPanel;
                    appMenuPopupPanel.getPathToSequence(appMenuCommand).run();
                }
            });
        })).setActionRichTooltip(appMenuCommand.getActionRichTooltip())).build();
        CommandButtonPresentationModel presentationModel = CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL).setHorizontalGapScaleFactor(0.5).setVerticalGapScaleFactor(0.5).build();
        CommandButtonProjection<Command> projection = clone.project(presentationModel);
        JCommandButton commandButton = (JCommandButton)projection.buildComponent();
        commandButton.putClientProperty("radiance.flamingo.internal.ribbon.taskbarCommand", appMenuCommand);
        this.taskbarComponents.add(commandButton);
        this.taskbarCommandMap.put(appMenuCommand, commandButton);
        this.fireStateChanged();
    }

    public synchronized void addTaskbarComponent(ComponentProjection<? extends JComponent, ? extends ComponentContentModel> projection) {
        JRibbonComponent ribbonComponent = new JRibbonComponent(projection);
        ribbonComponent.putClientProperty("radiance.flamingo.internal.ribbon.taskbarProjection", projection);
        this.taskbarComponents.add(ribbonComponent);
        this.fireStateChanged();
    }

    public synchronized boolean isShowingInTaskbar(ComponentContentModel componentContentModel) {
        for (Component taskbarComponent : this.taskbarComponents) {
            if (!(taskbarComponent instanceof JRibbonComponent) || ((JRibbonComponent)taskbarComponent).getProjection().getContentModel() != componentContentModel) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeTaskbarComponent(ComponentContentModel componentContentModel) {
        for (Component taskbarComponent : this.taskbarComponents) {
            if (!(taskbarComponent instanceof JRibbonComponent) || ((JRibbonComponent)taskbarComponent).getProjection().getContentModel() != componentContentModel) continue;
            this.taskbarComponents.remove(taskbarComponent);
            this.fireStateChanged();
            return;
        }
    }

    public synchronized void addTaskbarGalleryDropdown(RibbonGalleryProjection galleryProjection) {
        CommandPopupMenuProjection popupMenuProjection = JRibbonGallery.getExpandPopupMenu(galleryProjection, this.getComponentOrientation());
        Command galleryDropdownCommand = ((Command.Builder)((Command.Builder)Command.builder().setIconFactory(((RibbonGalleryContentModel)galleryProjection.getContentModel()).getIconFactory())).setSecondaryContentModel((CommandMenuContentModel)popupMenuProjection.getContentModel())).build();
        CommandButtonProjection<Command> galleryDropdownProjection = galleryDropdownCommand.project(CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL).setPopupMenuPresentationModel((AbstractPopupMenuPresentationModel)popupMenuProjection.getPresentationModel()).build());
        galleryDropdownProjection.setPopupMenuCustomizer(popupMenuProjection.getComponentCustomizer());
        galleryDropdownProjection.setCommandOverlays(popupMenuProjection.getCommandOverlays());
        JCommandButton galleryDropdown = (JCommandButton)galleryDropdownProjection.buildComponent();
        galleryDropdown.putClientProperty("radiance.flamingo.internal.ribbon.taskbarProjection", galleryProjection);
        this.taskbarComponents.add(galleryDropdown);
        this.taskbarGalleryMap.put((RibbonGalleryContentModel)galleryProjection.getContentModel(), galleryDropdown);
        this.fireStateChanged();
    }

    public synchronized boolean isShowingInTaskbar(RibbonGalleryContentModel galleryContentModel) {
        return this.taskbarGalleryMap.containsKey(galleryContentModel);
    }

    public synchronized void removeTaskbarGallery(RibbonGalleryContentModel galleryContentModel) {
        JCommandButton existing = this.taskbarGalleryMap.get(galleryContentModel);
        if (existing != null) {
            this.taskbarComponents.remove(existing);
            this.taskbarGalleryMap.remove(galleryContentModel);
            this.fireStateChanged();
        }
    }

    public synchronized void clearTaskbar() {
        this.taskbarCommandMap.clear();
        this.taskbarComponents.clear();
        this.fireStateChanged();
    }

    public synchronized void addTask(RibbonTask task) {
        task.setRibbon(this);
        this.tasks.add(task);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(task);
        }
        this.fireStateChanged();
    }

    public synchronized void addAnchoredCommand(CommandButtonProjection projection) {
        this.anchoredCommands.add(projection);
        this.fireStateChanged();
    }

    public synchronized void removeAnchoredCommand(CommandButtonProjection projection) {
        this.anchoredCommands.remove(projection);
        this.fireStateChanged();
    }

    public synchronized List<CommandButtonProjection> getAnchoredCommands() {
        return Collections.unmodifiableList(this.anchoredCommands);
    }

    public synchronized void addContextualTaskGroup(RibbonContextualTaskGroup group) {
        group.setRibbon(this);
        this.contextualTaskGroups.add(group);
        this.groupVisibilityMap.put(group, Boolean.FALSE);
        this.fireStateChanged();
    }

    public synchronized int getTaskCount() {
        return this.tasks.size();
    }

    public synchronized RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    public synchronized int getContextualTaskGroupCount() {
        return this.contextualTaskGroups.size();
    }

    public synchronized RibbonContextualTaskGroup getContextualTaskGroup(int index) {
        return this.contextualTaskGroups.get(index);
    }

    public synchronized void setSelectedTask(RibbonTask task) {
        boolean valid = this.tasks.contains(task);
        if (!valid) {
            for (int i = 0; i < this.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = this.getContextualTaskGroup(i);
                if (!this.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount(); ++j) {
                    if (group.getTask(j) != task) continue;
                    valid = true;
                    break;
                }
                if (valid) break;
            }
        }
        if (!valid) {
            throw new IllegalArgumentException("The specified task to be selected is either not part of this ribbon or not marked as visible");
        }
        for (AbstractRibbonBand ribbonBand : this.bands) {
            ribbonBand.setVisible(false);
        }
        this.bands.clear();
        for (int i = 0; i < task.getBandCount(); ++i) {
            AbstractRibbonBand ribbonBand;
            ribbonBand = task.getBand(i);
            ribbonBand.setVisible(true);
            this.bands.add(ribbonBand);
        }
        RibbonTask old = this.currentlySelectedTask;
        this.currentlySelectedTask = task;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("selectedTask", old, this.currentlySelectedTask);
        this.fireTaskSelectionChanged();
    }

    public synchronized RibbonTask getSelectedTask() {
        return this.currentlySelectedTask;
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceRibbonUI.createUI(this));
        for (Component comp : this.taskbarComponents) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized List<Component> getTaskbarComponents() {
        return Collections.unmodifiableList(this.taskbarComponents);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public synchronized void setVisible(RibbonContextualTaskGroup group, boolean isVisible) {
        this.groupVisibilityMap.put(group, isVisible);
        if (!isVisible) {
            boolean isSelectedBeingHidden = false;
            for (int i = 0; i < group.getTaskCount(); ++i) {
                if (this.getSelectedTask() != group.getTask(i)) continue;
                isSelectedBeingHidden = true;
                break;
            }
            if (isSelectedBeingHidden) {
                this.setSelectedTask(this.getTask(0));
            }
        }
        this.fireStateChanged();
        this.revalidate();
        SwingUtilities.getWindowAncestor(this).repaint();
    }

    public synchronized boolean isVisible(RibbonContextualTaskGroup group) {
        return this.groupVisibilityMap.get(group);
    }

    public synchronized void setApplicationMenuCommand(RibbonApplicationMenuCommandButtonProjection applicationMenuCommandProjection) {
        if (this.applicationMenuCommandProjection == applicationMenuCommandProjection) {
            return;
        }
        RibbonApplicationMenuProjection old = this.applicationMenuProjection;
        this.applicationMenuCommandProjection = applicationMenuCommandProjection;
        if (applicationMenuCommandProjection == null) {
            this.applicationMenuProjection = null;
        } else {
            RibbonApplicationMenuProjection ribbonApplicationMenuProjection;
            RibbonApplicationMenu ribbonApplicationMenu = (RibbonApplicationMenu)((Command)applicationMenuCommandProjection.getContentModel()).getSecondaryContentModel();
            this.applicationMenuProjection = ribbonApplicationMenuProjection = new RibbonApplicationMenuProjection(ribbonApplicationMenu, CommandButtonPresentationModel.withDefaults());
        }
        this.firePropertyChange("applicationMenu", old, this.applicationMenuProjection);
    }

    public RibbonApplicationMenuCommandButtonProjection getApplicationMenuCommandProjection() {
        return this.applicationMenuCommandProjection;
    }

    public synchronized RibbonApplicationMenuProjection getApplicationMenuProjection() {
        return this.applicationMenuProjection;
    }

    public synchronized boolean isMinimized() {
        return this.isMinimized;
    }

    public synchronized void setMinimized(boolean isMinimized) {
        boolean old = this.isMinimized;
        if (old != isMinimized) {
            this.isMinimized = isMinimized;
            this.firePropertyChange("minimized", old, this.isMinimized);
        }
    }

    public JRibbonFrame getRibbonFrame() {
        return this.ribbonFrame;
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.getRibbonFrame() != null) {
            throw new IllegalArgumentException("Can't hide ribbon on JRibbonFrame");
        }
        super.setVisible(flag);
    }

    public void setOnShowContextualMenuListener(OnShowContextualMenuListener onShowContextualMenuListener) {
        this.onShowContextualMenuListener = onShowContextualMenuListener;
    }

    public OnShowContextualMenuListener getOnShowContextualMenuListener() {
        return this.onShowContextualMenuListener;
    }

    public synchronized void addOnTaskSelectionChangedListener(OnTaskSelectionChangeListener listener) {
        if (this.onTaskSelectionChangeListeners == null) {
            this.onTaskSelectionChangeListeners = new ArrayList<OnTaskSelectionChangeListener>();
        }
        this.onTaskSelectionChangeListeners.add(listener);
    }

    public synchronized void removeOnTaskSelectionChangedListener(OnTaskSelectionChangeListener listener) {
        if (this.onTaskSelectionChangeListeners == null) {
            return;
        }
        this.onTaskSelectionChangeListeners.remove(listener);
    }

    private synchronized void fireTaskSelectionChanged() {
        if (this.onTaskSelectionChangeListeners == null) {
            return;
        }
        for (int i = this.onTaskSelectionChangeListeners.size() - 1; i >= 0; --i) {
            this.onTaskSelectionChangeListeners.get(i).onTaskSelectionChanged(this.currentlySelectedTask);
        }
    }

    @FunctionalInterface
    public static interface OnTaskSelectionChangeListener {
        public void onTaskSelectionChanged(RibbonTask var1);
    }

    public static interface OnShowContextualMenuListener {
        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, RibbonGalleryProjection var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, ComponentProjection<? extends JComponent, ? extends ComponentContentModel> var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, CommandButtonProjection<? extends Command> var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1);
    }
}

