/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.model.ImmutablePresentationModel;
import org.pushingpixels.substance.api.SubstanceSlices;

public class CommandStripPresentationModel
implements ImmutablePresentationModel {
    public static final double DEFAULT_GAP_SCALE_FACTOR_PRIMARY_AXIS = 0.75;
    public static final double DEFAULT_GAP_SCALE_FACTOR_SECONDARY_AXIS = 1.0;
    private CommandButtonPresentationState commandPresentationState;
    private SubstanceSlices.IconFilterStrategy activeIconFilterStrategy;
    private SubstanceSlices.IconFilterStrategy enabledIconFilterStrategy;
    private SubstanceSlices.IconFilterStrategy disabledIconFilterStrategy;
    private double hgapScaleFactor;
    private double vgapScaleFactor;
    private StripOrientation orientation;
    private boolean isFlat;
    private boolean isFocusable;
    private boolean toDismissPopupsOnActivation;

    private CommandStripPresentationModel() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CommandStripPresentationModel withDefaults() {
        return CommandStripPresentationModel.builder().build();
    }

    public CommandButtonPresentationState getCommandPresentationState() {
        return this.commandPresentationState;
    }

    public SubstanceSlices.IconFilterStrategy getActiveIconFilterStrategy() {
        return this.activeIconFilterStrategy;
    }

    public SubstanceSlices.IconFilterStrategy getEnabledIconFilterStrategy() {
        return this.enabledIconFilterStrategy;
    }

    public SubstanceSlices.IconFilterStrategy getDisabledIconFilterStrategy() {
        return this.disabledIconFilterStrategy;
    }

    public double getHorizontalGapScaleFactor() {
        return this.hgapScaleFactor;
    }

    public double getVerticalGapScaleFactor() {
        return this.vgapScaleFactor;
    }

    public StripOrientation getOrientation() {
        return this.orientation;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public boolean isFocusable() {
        return this.isFocusable;
    }

    public boolean isToDismissPopupsOnActivation() {
        return this.toDismissPopupsOnActivation;
    }

    public static class Builder {
        private CommandButtonPresentationState commandPresentationState = CommandButtonPresentationState.SMALL;
        private SubstanceSlices.IconFilterStrategy activeIconFilterStrategy = SubstanceSlices.IconFilterStrategy.ORIGINAL;
        private SubstanceSlices.IconFilterStrategy enabledIconFilterStrategy = SubstanceSlices.IconFilterStrategy.ORIGINAL;
        private SubstanceSlices.IconFilterStrategy disabledIconFilterStrategy = SubstanceSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
        private double hgapScaleFactor = -1.0;
        private double vgapScaleFactor = -1.0;
        private StripOrientation orientation = StripOrientation.HORIZONTAL;
        private boolean isFlat = false;
        private boolean isFocusable = true;
        private boolean toDismissPopupsOnActivation = true;

        public Builder setCommandPresentationState(CommandButtonPresentationState commandPresentationState) {
            this.commandPresentationState = commandPresentationState;
            return this;
        }

        public Builder setIconFilterStrategies(SubstanceSlices.IconFilterStrategy activeIconFilterStrategy, SubstanceSlices.IconFilterStrategy enabledIconFilterStrategy, SubstanceSlices.IconFilterStrategy disabledIconFilterStrategy) {
            this.activeIconFilterStrategy = activeIconFilterStrategy;
            this.enabledIconFilterStrategy = enabledIconFilterStrategy;
            this.disabledIconFilterStrategy = disabledIconFilterStrategy;
            return this;
        }

        public Builder setHorizontalGapScaleFactor(double hgapScaleFactor) {
            this.hgapScaleFactor = hgapScaleFactor;
            return this;
        }

        public Builder setVerticalGapScaleFactor(double vgapScaleFactor) {
            this.vgapScaleFactor = vgapScaleFactor;
            return this;
        }

        public Builder setOrientation(StripOrientation orientation) {
            this.orientation = orientation;
            return this;
        }

        public Builder setFlat(boolean flat) {
            this.isFlat = flat;
            return this;
        }

        public Builder setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return this;
        }

        public Builder setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return this;
        }

        public CommandStripPresentationModel build() {
            CommandStripPresentationModel presentationModel = new CommandStripPresentationModel();
            presentationModel.commandPresentationState = this.commandPresentationState;
            presentationModel.activeIconFilterStrategy = this.activeIconFilterStrategy;
            presentationModel.enabledIconFilterStrategy = this.enabledIconFilterStrategy;
            presentationModel.disabledIconFilterStrategy = this.disabledIconFilterStrategy;
            presentationModel.orientation = this.orientation;
            if (this.hgapScaleFactor < 0.0) {
                presentationModel.hgapScaleFactor = this.orientation == StripOrientation.HORIZONTAL ? 0.75 : 1.0;
            } else {
                presentationModel.hgapScaleFactor = this.hgapScaleFactor;
            }
            if (this.vgapScaleFactor < 0.0) {
                presentationModel.vgapScaleFactor = this.orientation == StripOrientation.VERTICAL ? 0.75 : 1.0;
            } else {
                presentationModel.vgapScaleFactor = this.vgapScaleFactor;
            }
            presentationModel.isFlat = this.isFlat;
            presentationModel.isFocusable = this.isFocusable;
            presentationModel.toDismissPopupsOnActivation = this.toDismissPopupsOnActivation;
            return presentationModel;
        }
    }

    public static enum StripOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

