/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.model.ChangeAware;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.model.ContentModel;
import org.pushingpixels.flamingo.internal.utils.WeakChangeSupport;

public class CommandMenuContentModel
implements ContentModel,
ChangeAware {
    private CommandPanelContentModel panelContentModel;
    private List<CommandGroup> commandGroups;
    private Command highlightedCommand;
    private final WeakChangeSupport weakChangeSupport = new WeakChangeSupport(this);
    private CommandGroup.CommandGroupListener commandGroupListener;
    private ChangeListener panelContentChangeListener;

    public CommandMenuContentModel(CommandGroup commands) {
        this(null, Collections.singletonList(commands));
    }

    public CommandMenuContentModel(CommandGroup ... commandGroups) {
        this(null, Arrays.asList(commandGroups));
    }

    public CommandMenuContentModel(List<CommandGroup> commands) {
        this(null, commands);
    }

    public CommandMenuContentModel(CommandPanelContentModel panelContentModel, List<CommandGroup> commands) {
        this.commandGroups = new ArrayList<CommandGroup>(commands);
        this.commandGroupListener = new CommandGroup.CommandGroupListener(){

            @Override
            public void onCommandAdded(Command command) {
                CommandMenuContentModel.this.fireStateChanged();
            }

            @Override
            public void onCommandRemoved(Command command) {
                CommandMenuContentModel.this.fireStateChanged();
            }

            @Override
            public void onAllCommandsRemoved() {
                CommandMenuContentModel.this.fireStateChanged();
            }
        };
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        }
        this.panelContentModel = panelContentModel;
        if (this.panelContentModel != null) {
            this.panelContentChangeListener = changeEvent -> this.fireStateChanged();
            this.panelContentModel.addChangeListener(this.panelContentChangeListener);
        }
    }

    public CommandPanelContentModel getPanelContentModel() {
        return this.panelContentModel;
    }

    public void addCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.add(commandGroupModel);
        commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        this.fireStateChanged();
    }

    public void removeCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.remove(commandGroupModel);
        commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
        this.fireStateChanged();
    }

    public void removeAllCommandGroups() {
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
        }
        this.commandGroups.clear();
        this.fireStateChanged();
    }

    public Command getHighlightedCommand() {
        return this.highlightedCommand;
    }

    public void setHighlightedCommand(Command highlightedCommand) {
        this.highlightedCommand = highlightedCommand;
        this.fireStateChanged();
    }

    public List<CommandGroup> getCommandGroups() {
        return Collections.unmodifiableList(this.commandGroups);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.weakChangeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.weakChangeSupport.removeChangeListener(l);
    }

    private void fireStateChanged() {
        this.weakChangeSupport.fireStateChanged();
    }
}

