/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Map;
import org.pushingpixels.neon.api.AsynchronousLoadListener;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.icon.NeonIcon;

public class IconDeckNeonIcon<T>
implements NeonIcon,
AsynchronousLoading {
    private NeonIcon currentIcon;
    private final Map<T, ? extends NeonIcon> iconDeck;

    public IconDeckNeonIcon(Map<T, ? extends NeonIcon> iconDeck) {
        if (iconDeck.isEmpty()) {
            throw new IllegalArgumentException("Icon deck is empty; must have at least one icon");
        }
        this.iconDeck = iconDeck;
        this.currentIcon = iconDeck.values().iterator().next();
    }

    public void setIcon(T key) {
        this.currentIcon = this.iconDeck.get(key);
    }

    public void setDimension(Dimension dim) {
        for (NeonIcon neonIcon : this.iconDeck.values()) {
            int currH = neonIcon.getIconHeight();
            int currW = neonIcon.getIconWidth();
            if (currH == dim.height && currW == dim.width) continue;
            neonIcon.setDimension(dim);
        }
    }

    public boolean supportsColorFilter() {
        for (NeonIcon neonIcon : this.iconDeck.values()) {
            if (neonIcon.supportsColorFilter()) continue;
            return false;
        }
        return true;
    }

    public void setColorFilter(NeonIcon.ColorFilter colorFilter) {
        for (NeonIcon neonIcon : this.iconDeck.values()) {
            neonIcon.setColorFilter(colorFilter);
        }
    }

    public int getIconHeight() {
        return this.currentIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.currentIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.currentIcon.paintIcon(c, g, x, y);
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (NeonIcon neonIcon : this.iconDeck.values()) {
            if (!(neonIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)neonIcon).addAsynchronousLoadListener(l);
        }
    }

    public boolean isLoading() {
        for (NeonIcon neonIcon : this.iconDeck.values()) {
            if (!(neonIcon instanceof AsynchronousLoading) || !((AsynchronousLoading)neonIcon).isLoading()) continue;
            return true;
        }
        return false;
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (NeonIcon neonIcon : this.iconDeck.values()) {
            if (!(neonIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)neonIcon).removeAsynchronousLoadListener(l);
        }
    }
}

