/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import org.pushingpixels.neon.api.icon.NeonIcon;

public class ColorNeonIcon
implements NeonIcon {
    protected int width;
    protected int height;
    private final Color color;

    public ColorNeonIcon(Dimension initialDim, Color color) {
        this.width = initialDim.width;
        this.height = initialDim.height;
        this.color = color;
    }

    public ColorNeonIcon(int initialDim, Color color) {
        this(new Dimension(initialDim, initialDim), color);
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public boolean supportsColorFilter() {
        return false;
    }

    public void setColorFilter(NeonIcon.ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
    }

    public static NeonIcon.Factory factory(Color color) {
        return () -> new ColorNeonIcon(16, color);
    }
}

